@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin

import com.pulumi.azurenative.keyvault.SecretArgs.builder
import com.pulumi.azurenative.keyvault.kotlin.inputs.SecretPropertiesArgs
import com.pulumi.azurenative.keyvault.kotlin.inputs.SecretPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource information with extended details.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2019-09-01.
 * Other available API versions: 2023-07-01.
 * ## Example Usage
 * ### Create a secret
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var secret = new AzureNative.KeyVault.Secret("secret", new()
 *     {
 *         Properties = new AzureNative.KeyVault.Inputs.SecretPropertiesArgs
 *         {
 *             Value = "secret-value",
 *         },
 *         ResourceGroupName = "sample-group",
 *         SecretName = "secret-name",
 *         VaultName = "sample-vault",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/keyvault/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := keyvault.NewSecret(ctx, "secret", &keyvault.SecretArgs{
 * 			Properties: &keyvault.SecretPropertiesArgs{
 * 				Value: pulumi.String("secret-value"),
 * 			},
 * 			ResourceGroupName: pulumi.String("sample-group"),
 * 			SecretName:        pulumi.String("secret-name"),
 * 			VaultName:         pulumi.String("sample-vault"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.keyvault.Secret;
 * import com.pulumi.azurenative.keyvault.SecretArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var secret = new Secret("secret", SecretArgs.builder()
 *             .properties(Map.of("value", "secret-value"))
 *             .resourceGroupName("sample-group")
 *             .secretName("secret-name")
 *             .vaultName("sample-vault")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:keyvault:Secret secret-name /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}/secrets/{secretName}
 * ```
 * @property properties Properties of the secret
 * @property resourceGroupName The name of the Resource Group to which the vault belongs.
 * @property secretName Name of the secret. The value you provide may be copied globally for the purpose of running the service. The value provided should not include personally identifiable or sensitive information.
 * @property tags The tags that will be assigned to the secret.
 * @property vaultName Name of the vault
 */
public data class SecretArgs(
    public val properties: Output<SecretPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val secretName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vaultName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.keyvault.SecretArgs> {
    override fun toJava(): com.pulumi.azurenative.keyvault.SecretArgs =
        com.pulumi.azurenative.keyvault.SecretArgs.builder()
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .secretName(secretName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vaultName(vaultName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecretArgs].
 */
@PulumiTagMarker
public class SecretArgsBuilder internal constructor() {
    private var properties: Output<SecretPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var secretName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vaultName: Output<String>? = null

    /**
     * @param value Properties of the secret
     */
    @JvmName("wdcurvqtosvdivrv")
    public suspend fun properties(`value`: Output<SecretPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the Resource Group to which the vault belongs.
     */
    @JvmName("bbmklnisqmobfdec")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the secret. The value you provide may be copied globally for the purpose of running the service. The value provided should not include personally identifiable or sensitive information.
     */
    @JvmName("ofsnefbrkwkfbmqi")
    public suspend fun secretName(`value`: Output<String>) {
        this.secretName = value
    }

    /**
     * @param value The tags that will be assigned to the secret.
     */
    @JvmName("oblavkxiigamnujx")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the vault
     */
    @JvmName("rgpjvcmkmkxjkpss")
    public suspend fun vaultName(`value`: Output<String>) {
        this.vaultName = value
    }

    /**
     * @param value Properties of the secret
     */
    @JvmName("ciobgkllcgqjwlqy")
    public suspend fun properties(`value`: SecretPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of the secret
     */
    @JvmName("cqhhkeqhkfvtvocr")
    public suspend fun properties(argument: suspend SecretPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SecretPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the Resource Group to which the vault belongs.
     */
    @JvmName("cfqwrkdsgqhxowba")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the secret. The value you provide may be copied globally for the purpose of running the service. The value provided should not include personally identifiable or sensitive information.
     */
    @JvmName("lvakhasdhmnshgov")
    public suspend fun secretName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretName = mapped
    }

    /**
     * @param value The tags that will be assigned to the secret.
     */
    @JvmName("uscrscshvwpcwgnm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags that will be assigned to the secret.
     */
    @JvmName("dhgqshlselyeyqrx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Name of the vault
     */
    @JvmName("aeumhnfxbxobgsxp")
    public suspend fun vaultName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vaultName = mapped
    }

    internal fun build(): SecretArgs = SecretArgs(
        properties = properties,
        resourceGroupName = resourceGroupName,
        secretName = secretName,
        tags = tags,
        vaultName = vaultName,
    )
}
