@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin

import com.pulumi.azurenative.keyvault.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.keyvault.kotlin.outputs.VaultPropertiesResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.keyvault.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.keyvault.kotlin.outputs.VaultPropertiesResponse.Companion.toKotlin as vaultPropertiesResponseToKotlin

/**
 * Builder for [Vault].
 */
@PulumiTagMarker
public class VaultResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VaultArgs = VaultArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VaultArgsBuilder.() -> Unit) {
        val builder = VaultArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Vault {
        val builtJavaResource = com.pulumi.azurenative.keyvault.Vault(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Vault(builtJavaResource)
    }
}

/**
 * Resource information with extended details.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2019-09-01.
 * Other available API versions: 2018-02-14-preview, 2023-07-01.
 * ## Example Usage
 * ### Create a new vault or update an existing vault
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vault = new AzureNative.KeyVault.Vault("vault", new()
 *     {
 *         Location = "westus",
 *         Properties = new AzureNative.KeyVault.Inputs.VaultPropertiesArgs
 *         {
 *             AccessPolicies = new[]
 *             {
 *                 new AzureNative.KeyVault.Inputs.AccessPolicyEntryArgs
 *                 {
 *                     ObjectId = "00000000-0000-0000-0000-000000000000",
 *                     Permissions = new AzureNative.KeyVault.Inputs.PermissionsArgs
 *                     {
 *                         Certificates = new[]
 *                         {
 *                             "get",
 *                             "list",
 *                             "delete",
 *                             "create",
 *                             "import",
 *                             "update",
 *                             "managecontacts",
 *                             "getissuers",
 *                             "listissuers",
 *                             "setissuers",
 *                             "deleteissuers",
 *                             "manageissuers",
 *                             "recover",
 *                             "purge",
 *                         },
 *                         Keys = new[]
 *                         {
 *                             "encrypt",
 *                             "decrypt",
 *                             "wrapKey",
 *                             "unwrapKey",
 *                             "sign",
 *                             "verify",
 *                             "get",
 *                             "list",
 *                             "create",
 *                             "update",
 *                             "import",
 *                             "delete",
 *                             "backup",
 *                             "restore",
 *                             "recover",
 *                             "purge",
 *                         },
 *                         Secrets = new[]
 *                         {
 *                             "get",
 *                             "list",
 *                             "set",
 *                             "delete",
 *                             "backup",
 *                             "restore",
 *                             "recover",
 *                             "purge",
 *                         },
 *                     },
 *                     TenantId = "00000000-0000-0000-0000-000000000000",
 *                 },
 *             },
 *             EnabledForDeployment = true,
 *             EnabledForDiskEncryption = true,
 *             EnabledForTemplateDeployment = true,
 *             PublicNetworkAccess = "Enabled",
 *             Sku = new AzureNative.KeyVault.Inputs.SkuArgs
 *             {
 *                 Family = "A",
 *                 Name = AzureNative.KeyVault.SkuName.Standard,
 *             },
 *             TenantId = "00000000-0000-0000-0000-000000000000",
 *         },
 *         ResourceGroupName = "sample-resource-group",
 *         VaultName = "sample-vault",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/keyvault/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := keyvault.NewVault(ctx, "vault", &keyvault.VaultArgs{
 * Location: pulumi.String("westus"),
 * Properties: keyvault.VaultPropertiesResponse{
 * AccessPolicies: keyvault.AccessPolicyEntryArray{
 * interface{}{
 * ObjectId: pulumi.String("00000000-0000-0000-0000-000000000000"),
 * Permissions: &keyvault.PermissionsArgs{
 * Certificates: pulumi.StringArray{
 * pulumi.String("get"),
 * pulumi.String("list"),
 * pulumi.String("delete"),
 * pulumi.String("create"),
 * pulumi.String("import"),
 * pulumi.String("update"),
 * pulumi.String("managecontacts"),
 * pulumi.String("getissuers"),
 * pulumi.String("listissuers"),
 * pulumi.String("setissuers"),
 * pulumi.String("deleteissuers"),
 * pulumi.String("manageissuers"),
 * pulumi.String("recover"),
 * pulumi.String("purge"),
 * },
 * Keys: pulumi.StringArray{
 * pulumi.String("encrypt"),
 * pulumi.String("decrypt"),
 * pulumi.String("wrapKey"),
 * pulumi.String("unwrapKey"),
 * pulumi.String("sign"),
 * pulumi.String("verify"),
 * pulumi.String("get"),
 * pulumi.String("list"),
 * pulumi.String("create"),
 * pulumi.String("update"),
 * pulumi.String("import"),
 * pulumi.String("delete"),
 * pulumi.String("backup"),
 * pulumi.String("restore"),
 * pulumi.String("recover"),
 * pulumi.String("purge"),
 * },
 * Secrets: pulumi.StringArray{
 * pulumi.String("get"),
 * pulumi.String("list"),
 * pulumi.String("set"),
 * pulumi.String("delete"),
 * pulumi.String("backup"),
 * pulumi.String("restore"),
 * pulumi.String("recover"),
 * pulumi.String("purge"),
 * },
 * },
 * TenantId: pulumi.String("00000000-0000-0000-0000-000000000000"),
 * },
 * },
 * EnabledForDeployment: pulumi.Bool(true),
 * EnabledForDiskEncryption: pulumi.Bool(true),
 * EnabledForTemplateDeployment: pulumi.Bool(true),
 * PublicNetworkAccess: pulumi.String("Enabled"),
 * Sku: &keyvault.SkuArgs{
 * Family: pulumi.String("A"),
 * Name: keyvault.SkuNameStandard,
 * },
 * TenantId: pulumi.String("00000000-0000-0000-0000-000000000000"),
 * },
 * ResourceGroupName: pulumi.String("sample-resource-group"),
 * VaultName: pulumi.String("sample-vault"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.keyvault.Vault;
 * import com.pulumi.azurenative.keyvault.VaultArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vault = new Vault("vault", VaultArgs.builder()
 *             .location("westus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("accessPolicies", Map.ofEntries(
 *                     Map.entry("objectId", "00000000-0000-0000-0000-000000000000"),
 *                     Map.entry("permissions", Map.ofEntries(
 *                         Map.entry("certificates",
 *                             "get",
 *                             "list",
 *                             "delete",
 *                             "create",
 *                             "import",
 *                             "update",
 *                             "managecontacts",
 *                             "getissuers",
 *                             "listissuers",
 *                             "setissuers",
 *                             "deleteissuers",
 *                             "manageissuers",
 *                             "recover",
 *                             "purge"),
 *                         Map.entry("keys",
 *                             "encrypt",
 *                             "decrypt",
 *                             "wrapKey",
 *                             "unwrapKey",
 *                             "sign",
 *                             "verify",
 *                             "get",
 *                             "list",
 *                             "create",
 *                             "update",
 *                             "import",
 *                             "delete",
 *                             "backup",
 *                             "restore",
 *                             "recover",
 *                             "purge"),
 *                         Map.entry("secrets",
 *                             "get",
 *                             "list",
 *                             "set",
 *                             "delete",
 *                             "backup",
 *                             "restore",
 *                             "recover",
 *                             "purge")
 *                     )),
 *                     Map.entry("tenantId", "00000000-0000-0000-0000-000000000000")
 *                 )),
 *                 Map.entry("enabledForDeployment", true),
 *                 Map.entry("enabledForDiskEncryption", true),
 *                 Map.entry("enabledForTemplateDeployment", true),
 *                 Map.entry("publicNetworkAccess", "Enabled"),
 *                 Map.entry("sku", Map.ofEntries(
 *                     Map.entry("family", "A"),
 *                     Map.entry("name", "standard")
 *                 )),
 *                 Map.entry("tenantId", "00000000-0000-0000-0000-000000000000")
 *             ))
 *             .resourceGroupName("sample-resource-group")
 *             .vaultName("sample-vault")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a vault with network acls
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vault = new AzureNative.KeyVault.Vault("vault", new()
 *     {
 *         Location = "westus",
 *         Properties = new AzureNative.KeyVault.Inputs.VaultPropertiesArgs
 *         {
 *             EnabledForDeployment = true,
 *             EnabledForDiskEncryption = true,
 *             EnabledForTemplateDeployment = true,
 *             NetworkAcls = new AzureNative.KeyVault.Inputs.NetworkRuleSetArgs
 *             {
 *                 Bypass = "AzureServices",
 *                 DefaultAction = "Deny",
 *                 IpRules = new[]
 *                 {
 *                     new AzureNative.KeyVault.Inputs.IPRuleArgs
 *                     {
 *                         Value = "124.56.78.91",
 *                     },
 *                     new AzureNative.KeyVault.Inputs.IPRuleArgs
 *                     {
 *                         Value = "'10.91.4.0/24'",
 *                     },
 *                 },
 *                 VirtualNetworkRules = new[]
 *                 {
 *                     new AzureNative.KeyVault.Inputs.VirtualNetworkRuleArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1",
 *                     },
 *                 },
 *             },
 *             Sku = new AzureNative.KeyVault.Inputs.SkuArgs
 *             {
 *                 Family = "A",
 *                 Name = AzureNative.KeyVault.SkuName.Standard,
 *             },
 *             TenantId = "00000000-0000-0000-0000-000000000000",
 *         },
 *         ResourceGroupName = "sample-resource-group",
 *         VaultName = "sample-vault",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/keyvault/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := keyvault.NewVault(ctx, "vault", &keyvault.VaultArgs{
 * Location: pulumi.String("westus"),
 * Properties: keyvault.VaultPropertiesResponse{
 * EnabledForDeployment: pulumi.Bool(true),
 * EnabledForDiskEncryption: pulumi.Bool(true),
 * EnabledForTemplateDeployment: pulumi.Bool(true),
 * NetworkAcls: interface{}{
 * Bypass: pulumi.String("AzureServices"),
 * DefaultAction: pulumi.String("Deny"),
 * IpRules: keyvault.IPRuleArray{
 * &keyvault.IPRuleArgs{
 * Value: pulumi.String("124.56.78.91"),
 * },
 * &keyvault.IPRuleArgs{
 * Value: pulumi.String("'10.91.4.0/24'"),
 * },
 * },
 * VirtualNetworkRules: keyvault.VirtualNetworkRuleArray{
 * &keyvault.VirtualNetworkRuleArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1"),
 * },
 * },
 * },
 * Sku: &keyvault.SkuArgs{
 * Family: pulumi.String("A"),
 * Name: keyvault.SkuNameStandard,
 * },
 * TenantId: pulumi.String("00000000-0000-0000-0000-000000000000"),
 * },
 * ResourceGroupName: pulumi.String("sample-resource-group"),
 * VaultName: pulumi.String("sample-vault"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.keyvault.Vault;
 * import com.pulumi.azurenative.keyvault.VaultArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vault = new Vault("vault", VaultArgs.builder()
 *             .location("westus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("enabledForDeployment", true),
 *                 Map.entry("enabledForDiskEncryption", true),
 *                 Map.entry("enabledForTemplateDeployment", true),
 *                 Map.entry("networkAcls", Map.ofEntries(
 *                     Map.entry("bypass", "AzureServices"),
 *                     Map.entry("defaultAction", "Deny"),
 *                     Map.entry("ipRules",
 *                         Map.of("value", "124.56.78.91"),
 *                         Map.of("value", "'10.91.4.0/24'")),
 *                     Map.entry("virtualNetworkRules", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1"))
 *                 )),
 *                 Map.entry("sku", Map.ofEntries(
 *                     Map.entry("family", "A"),
 *                     Map.entry("name", "standard")
 *                 )),
 *                 Map.entry("tenantId", "00000000-0000-0000-0000-000000000000")
 *             ))
 *             .resourceGroupName("sample-resource-group")
 *             .vaultName("sample-vault")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:keyvault:Vault sample-vault /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}
 * ```
 */
public class Vault internal constructor(
    override val javaResource: com.pulumi.azurenative.keyvault.Vault,
) : KotlinCustomResource(javaResource, VaultMapper) {
    /**
     * Azure location of the key vault resource.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Name of the key vault resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of the vault
     */
    public val properties: Output<VaultPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                vaultPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * System metadata for the key vault.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Tags assigned to the key vault resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type of the key vault resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object VaultMapper : ResourceMapper<Vault> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.keyvault.Vault::class == javaResource::class

    override fun map(javaResource: Resource): Vault = Vault(
        javaResource as
            com.pulumi.azurenative.keyvault.Vault,
    )
}

/**
 * @see [Vault].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Vault].
 */
public suspend fun vault(name: String, block: suspend VaultResourceBuilder.() -> Unit): Vault {
    val builder = VaultResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Vault].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vault(name: String): Vault {
    val builder = VaultResourceBuilder()
    builder.name(name)
    return builder.build()
}
