@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of the action. The value should be compared case-insensitively.
 */
public enum class KeyRotationPolicyActionType(
    public val javaValue: com.pulumi.azurenative.keyvault.enums.KeyRotationPolicyActionType,
) : ConvertibleToJava<com.pulumi.azurenative.keyvault.enums.KeyRotationPolicyActionType> {
    /**
     * Rotate the key based on the key policy.
     */
    Rotate(com.pulumi.azurenative.keyvault.enums.KeyRotationPolicyActionType.Rotate),

    /**
     * Trigger Event Grid events. Defaults to 30 days before expiry. Key Vault only.
     */
    Notify(com.pulumi.azurenative.keyvault.enums.KeyRotationPolicyActionType.Notify),
    ;

    override fun toJava(): com.pulumi.azurenative.keyvault.enums.KeyRotationPolicyActionType =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.keyvault.enums.KeyRotationPolicyActionType):
            KeyRotationPolicyActionType =
            KeyRotationPolicyActionType.values().first { it.javaValue == javaType }
    }
}
