@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Indicates whether the connection has been approved, rejected or removed by the key vault owner.
 */
public enum class PrivateEndpointServiceConnectionStatus(
    public val javaValue:
    com.pulumi.azurenative.keyvault.enums.PrivateEndpointServiceConnectionStatus,
) : ConvertibleToJava<com.pulumi.azurenative.keyvault.enums.PrivateEndpointServiceConnectionStatus> {
    Pending(com.pulumi.azurenative.keyvault.enums.PrivateEndpointServiceConnectionStatus.Pending),
    Approved(com.pulumi.azurenative.keyvault.enums.PrivateEndpointServiceConnectionStatus.Approved),
    Rejected(com.pulumi.azurenative.keyvault.enums.PrivateEndpointServiceConnectionStatus.Rejected),
    Disconnected(com.pulumi.azurenative.keyvault.enums.PrivateEndpointServiceConnectionStatus.Disconnected),
    ;

    override fun toJava():
        com.pulumi.azurenative.keyvault.enums.PrivateEndpointServiceConnectionStatus = javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.keyvault.enums.PrivateEndpointServiceConnectionStatus):
            PrivateEndpointServiceConnectionStatus =
            PrivateEndpointServiceConnectionStatus.values().first { it.javaValue == javaType }
    }
}
