@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.inputs

import com.pulumi.azurenative.keyvault.inputs.GetKeyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property keyName The name of the key to be retrieved.
 * @property resourceGroupName The name of the resource group which contains the specified key vault.
 * @property vaultName The name of the vault which contains the key to be retrieved.
 */
public data class GetKeyPlainArgs(
    public val keyName: String,
    public val resourceGroupName: String,
    public val vaultName: String,
) : ConvertibleToJava<com.pulumi.azurenative.keyvault.inputs.GetKeyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.keyvault.inputs.GetKeyPlainArgs =
        com.pulumi.azurenative.keyvault.inputs.GetKeyPlainArgs.builder()
            .keyName(keyName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .vaultName(vaultName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetKeyPlainArgs].
 */
@PulumiTagMarker
public class GetKeyPlainArgsBuilder internal constructor() {
    private var keyName: String? = null

    private var resourceGroupName: String? = null

    private var vaultName: String? = null

    /**
     * @param value The name of the key to be retrieved.
     */
    @JvmName("odhjxtmmgnaoqhsd")
    public suspend fun keyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.keyName = mapped
    }

    /**
     * @param value The name of the resource group which contains the specified key vault.
     */
    @JvmName("ufuotxqyfnlemcoq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the vault which contains the key to be retrieved.
     */
    @JvmName("xlwijrlwcrsosdtl")
    public suspend fun vaultName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vaultName = mapped
    }

    internal fun build(): GetKeyPlainArgs = GetKeyPlainArgs(
        keyName = keyName ?: throw PulumiNullFieldException("keyName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        vaultName = vaultName ?: throw PulumiNullFieldException("vaultName"),
    )
}
