@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.inputs

import com.pulumi.azurenative.keyvault.inputs.GetVaultPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the Resource Group to which the vault belongs.
 * @property vaultName The name of the vault.
 */
public data class GetVaultPlainArgs(
    public val resourceGroupName: String,
    public val vaultName: String,
) : ConvertibleToJava<com.pulumi.azurenative.keyvault.inputs.GetVaultPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.keyvault.inputs.GetVaultPlainArgs =
        com.pulumi.azurenative.keyvault.inputs.GetVaultPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .vaultName(vaultName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVaultPlainArgs].
 */
@PulumiTagMarker
public class GetVaultPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var vaultName: String? = null

    /**
     * @param value The name of the Resource Group to which the vault belongs.
     */
    @JvmName("nwrsfyqiniwfkagr")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the vault.
     */
    @JvmName("whworarnetgyygyf")
    public suspend fun vaultName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vaultName = mapped
    }

    internal fun build(): GetVaultPlainArgs = GetVaultPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        vaultName = vaultName ?: throw PulumiNullFieldException("vaultName"),
    )
}
