@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.inputs

import com.pulumi.azurenative.keyvault.inputs.LifetimeActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property action The action of key rotation policy lifetimeAction.
 * @property trigger The trigger of key rotation policy lifetimeAction.
 */
public data class LifetimeActionArgs(
    public val action: Output<ActionArgs>? = null,
    public val trigger: Output<TriggerArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.keyvault.inputs.LifetimeActionArgs> {
    override fun toJava(): com.pulumi.azurenative.keyvault.inputs.LifetimeActionArgs =
        com.pulumi.azurenative.keyvault.inputs.LifetimeActionArgs.builder()
            .action(action?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .trigger(trigger?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [LifetimeActionArgs].
 */
@PulumiTagMarker
public class LifetimeActionArgsBuilder internal constructor() {
    private var action: Output<ActionArgs>? = null

    private var trigger: Output<TriggerArgs>? = null

    /**
     * @param value The action of key rotation policy lifetimeAction.
     */
    @JvmName("qplhasrjftcckrbg")
    public suspend fun action(`value`: Output<ActionArgs>) {
        this.action = value
    }

    /**
     * @param value The trigger of key rotation policy lifetimeAction.
     */
    @JvmName("yvsanfhqmloxexoc")
    public suspend fun trigger(`value`: Output<TriggerArgs>) {
        this.trigger = value
    }

    /**
     * @param value The action of key rotation policy lifetimeAction.
     */
    @JvmName("bulrpnjqoucsxwxk")
    public suspend fun action(`value`: ActionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param argument The action of key rotation policy lifetimeAction.
     */
    @JvmName("crtoedeytmcblkdj")
    public suspend fun action(argument: suspend ActionArgsBuilder.() -> Unit) {
        val toBeMapped = ActionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.action = mapped
    }

    /**
     * @param value The trigger of key rotation policy lifetimeAction.
     */
    @JvmName("exgmkdemhegsxppu")
    public suspend fun trigger(`value`: TriggerArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trigger = mapped
    }

    /**
     * @param argument The trigger of key rotation policy lifetimeAction.
     */
    @JvmName("rflpytfirgnbcvmg")
    public suspend fun trigger(argument: suspend TriggerArgsBuilder.() -> Unit) {
        val toBeMapped = TriggerArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.trigger = mapped
    }

    internal fun build(): LifetimeActionArgs = LifetimeActionArgs(
        action = action,
        trigger = trigger,
    )
}
