@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.inputs

import com.pulumi.azurenative.keyvault.inputs.MHSMIPRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A rule governing the accessibility of a managed HSM pool from a specific IP address or IP range.
 * @property value An IPv4 address range in CIDR notation, such as '124.56.78.91' (simple IP address) or '124.56.78.0/24' (all addresses that start with 124.56.78).
 */
public data class MHSMIPRuleArgs(
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.keyvault.inputs.MHSMIPRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.keyvault.inputs.MHSMIPRuleArgs =
        com.pulumi.azurenative.keyvault.inputs.MHSMIPRuleArgs.builder()
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MHSMIPRuleArgs].
 */
@PulumiTagMarker
public class MHSMIPRuleArgsBuilder internal constructor() {
    private var `value`: Output<String>? = null

    /**
     * @param value An IPv4 address range in CIDR notation, such as '124.56.78.91' (simple IP address) or '124.56.78.0/24' (all addresses that start with 124.56.78).
     */
    @JvmName("frtopxymokkgmlhu")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value An IPv4 address range in CIDR notation, such as '124.56.78.91' (simple IP address) or '124.56.78.0/24' (all addresses that start with 124.56.78).
     */
    @JvmName("bnvtwywnajbmmvvt")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): MHSMIPRuleArgs = MHSMIPRuleArgs(
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
