@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.inputs

import com.pulumi.azurenative.keyvault.inputs.MHSMNetworkRuleSetArgs.builder
import com.pulumi.azurenative.keyvault.kotlin.enums.NetworkRuleAction
import com.pulumi.azurenative.keyvault.kotlin.enums.NetworkRuleBypassOptions
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A set of rules governing the network accessibility of a managed hsm pool.
 * @property bypass Tells what traffic can bypass network rules. This can be 'AzureServices' or 'None'.  If not specified the default is 'AzureServices'.
 * @property defaultAction The default action when no rule from ipRules and from virtualNetworkRules match. This is only used after the bypass property has been evaluated.
 * @property ipRules The list of IP address rules.
 * @property virtualNetworkRules The list of virtual network rules.
 */
public data class MHSMNetworkRuleSetArgs(
    public val bypass: Output<Either<String, NetworkRuleBypassOptions>>? = null,
    public val defaultAction: Output<Either<String, NetworkRuleAction>>? = null,
    public val ipRules: Output<List<MHSMIPRuleArgs>>? = null,
    public val virtualNetworkRules: Output<List<MHSMVirtualNetworkRuleArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.keyvault.inputs.MHSMNetworkRuleSetArgs> {
    override fun toJava(): com.pulumi.azurenative.keyvault.inputs.MHSMNetworkRuleSetArgs =
        com.pulumi.azurenative.keyvault.inputs.MHSMNetworkRuleSetArgs.builder()
            .bypass(
                bypass?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .defaultAction(
                defaultAction?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .ipRules(
                ipRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .virtualNetworkRules(
                virtualNetworkRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [MHSMNetworkRuleSetArgs].
 */
@PulumiTagMarker
public class MHSMNetworkRuleSetArgsBuilder internal constructor() {
    private var bypass: Output<Either<String, NetworkRuleBypassOptions>>? = null

    private var defaultAction: Output<Either<String, NetworkRuleAction>>? = null

    private var ipRules: Output<List<MHSMIPRuleArgs>>? = null

    private var virtualNetworkRules: Output<List<MHSMVirtualNetworkRuleArgs>>? = null

    /**
     * @param value Tells what traffic can bypass network rules. This can be 'AzureServices' or 'None'.  If not specified the default is 'AzureServices'.
     */
    @JvmName("liaweftqeeminbcx")
    public suspend fun bypass(`value`: Output<Either<String, NetworkRuleBypassOptions>>) {
        this.bypass = value
    }

    /**
     * @param value The default action when no rule from ipRules and from virtualNetworkRules match. This is only used after the bypass property has been evaluated.
     */
    @JvmName("gmasmjjmbnqluimd")
    public suspend fun defaultAction(`value`: Output<Either<String, NetworkRuleAction>>) {
        this.defaultAction = value
    }

    /**
     * @param value The list of IP address rules.
     */
    @JvmName("nygxjjjhnpseueha")
    public suspend fun ipRules(`value`: Output<List<MHSMIPRuleArgs>>) {
        this.ipRules = value
    }

    @JvmName("fgomyjmrjjcqigvo")
    public suspend fun ipRules(vararg values: Output<MHSMIPRuleArgs>) {
        this.ipRules = Output.all(values.asList())
    }

    /**
     * @param values The list of IP address rules.
     */
    @JvmName("wcefmygfyknbtypj")
    public suspend fun ipRules(values: List<Output<MHSMIPRuleArgs>>) {
        this.ipRules = Output.all(values)
    }

    /**
     * @param value The list of virtual network rules.
     */
    @JvmName("avlwwbyrdammoexj")
    public suspend fun virtualNetworkRules(`value`: Output<List<MHSMVirtualNetworkRuleArgs>>) {
        this.virtualNetworkRules = value
    }

    @JvmName("cldhmxqwfmetryyo")
    public suspend fun virtualNetworkRules(vararg values: Output<MHSMVirtualNetworkRuleArgs>) {
        this.virtualNetworkRules = Output.all(values.asList())
    }

    /**
     * @param values The list of virtual network rules.
     */
    @JvmName("flpbffdrttmdepet")
    public suspend fun virtualNetworkRules(values: List<Output<MHSMVirtualNetworkRuleArgs>>) {
        this.virtualNetworkRules = Output.all(values)
    }

    /**
     * @param value Tells what traffic can bypass network rules. This can be 'AzureServices' or 'None'.  If not specified the default is 'AzureServices'.
     */
    @JvmName("fniqtksipjibfdix")
    public suspend fun bypass(`value`: Either<String, NetworkRuleBypassOptions>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bypass = mapped
    }

    /**
     * @param value Tells what traffic can bypass network rules. This can be 'AzureServices' or 'None'.  If not specified the default is 'AzureServices'.
     */
    @JvmName("ykrgaspvppoyjwev")
    public fun bypass(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NetworkRuleBypassOptions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bypass = mapped
    }

    /**
     * @param value Tells what traffic can bypass network rules. This can be 'AzureServices' or 'None'.  If not specified the default is 'AzureServices'.
     */
    @JvmName("fgsrndxvjllxoxti")
    public fun bypass(`value`: NetworkRuleBypassOptions) {
        val toBeMapped = Either.ofRight<String, NetworkRuleBypassOptions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bypass = mapped
    }

    /**
     * @param value The default action when no rule from ipRules and from virtualNetworkRules match. This is only used after the bypass property has been evaluated.
     */
    @JvmName("ctglvfqpmkrepbxd")
    public suspend fun defaultAction(`value`: Either<String, NetworkRuleAction>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultAction = mapped
    }

    /**
     * @param value The default action when no rule from ipRules and from virtualNetworkRules match. This is only used after the bypass property has been evaluated.
     */
    @JvmName("vhbhrvkjlaluavcn")
    public fun defaultAction(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NetworkRuleAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultAction = mapped
    }

    /**
     * @param value The default action when no rule from ipRules and from virtualNetworkRules match. This is only used after the bypass property has been evaluated.
     */
    @JvmName("tmfqyjkmrotobtna")
    public fun defaultAction(`value`: NetworkRuleAction) {
        val toBeMapped = Either.ofRight<String, NetworkRuleAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultAction = mapped
    }

    /**
     * @param value The list of IP address rules.
     */
    @JvmName("ysaqvjybdhcyavcd")
    public suspend fun ipRules(`value`: List<MHSMIPRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipRules = mapped
    }

    /**
     * @param argument The list of IP address rules.
     */
    @JvmName("ehnpxyrntxmxjftf")
    public suspend fun ipRules(argument: List<suspend MHSMIPRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { MHSMIPRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipRules = mapped
    }

    /**
     * @param argument The list of IP address rules.
     */
    @JvmName("sqqofhqfegtelocj")
    public suspend fun ipRules(vararg argument: suspend MHSMIPRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { MHSMIPRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipRules = mapped
    }

    /**
     * @param argument The list of IP address rules.
     */
    @JvmName("hbtlthhrwseaqmdm")
    public suspend fun ipRules(argument: suspend MHSMIPRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(MHSMIPRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipRules = mapped
    }

    /**
     * @param values The list of IP address rules.
     */
    @JvmName("yahyiihtdgehwyuk")
    public suspend fun ipRules(vararg values: MHSMIPRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipRules = mapped
    }

    /**
     * @param value The list of virtual network rules.
     */
    @JvmName("bdrodpvmyqyeriqc")
    public suspend fun virtualNetworkRules(`value`: List<MHSMVirtualNetworkRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkRules = mapped
    }

    /**
     * @param argument The list of virtual network rules.
     */
    @JvmName("fvftmxoicuokmtax")
    public suspend
    fun virtualNetworkRules(argument: List<suspend MHSMVirtualNetworkRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MHSMVirtualNetworkRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.virtualNetworkRules = mapped
    }

    /**
     * @param argument The list of virtual network rules.
     */
    @JvmName("xvonhrpovvhsrucq")
    public suspend fun virtualNetworkRules(
        vararg
        argument: suspend MHSMVirtualNetworkRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MHSMVirtualNetworkRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.virtualNetworkRules = mapped
    }

    /**
     * @param argument The list of virtual network rules.
     */
    @JvmName("epsmkamnnfjqrqyk")
    public suspend
    fun virtualNetworkRules(argument: suspend MHSMVirtualNetworkRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(MHSMVirtualNetworkRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.virtualNetworkRules = mapped
    }

    /**
     * @param values The list of virtual network rules.
     */
    @JvmName("sqldxsbmkoukhxho")
    public suspend fun virtualNetworkRules(vararg values: MHSMVirtualNetworkRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualNetworkRules = mapped
    }

    internal fun build(): MHSMNetworkRuleSetArgs = MHSMNetworkRuleSetArgs(
        bypass = bypass,
        defaultAction = defaultAction,
        ipRules = ipRules,
        virtualNetworkRules = virtualNetworkRules,
    )
}
