@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.inputs

import com.pulumi.azurenative.keyvault.inputs.MHSMPrivateLinkServiceConnectionStateArgs.builder
import com.pulumi.azurenative.keyvault.kotlin.enums.ActionsRequired
import com.pulumi.azurenative.keyvault.kotlin.enums.PrivateEndpointServiceConnectionStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An object that represents the approval state of the private link connection.
 * @property actionsRequired A message indicating if changes on the service provider require any updates on the consumer.
 * @property description The reason for approval or rejection.
 * @property status Indicates whether the connection has been approved, rejected or removed by the key vault owner.
 */
public data class MHSMPrivateLinkServiceConnectionStateArgs(
    public val actionsRequired: Output<Either<String, ActionsRequired>>? = null,
    public val description: Output<String>? = null,
    public val status: Output<Either<String, PrivateEndpointServiceConnectionStatus>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.keyvault.inputs.MHSMPrivateLinkServiceConnectionStateArgs> {
    override fun toJava():
        com.pulumi.azurenative.keyvault.inputs.MHSMPrivateLinkServiceConnectionStateArgs =
        com.pulumi.azurenative.keyvault.inputs.MHSMPrivateLinkServiceConnectionStateArgs.builder()
            .actionsRequired(
                actionsRequired?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [MHSMPrivateLinkServiceConnectionStateArgs].
 */
@PulumiTagMarker
public class MHSMPrivateLinkServiceConnectionStateArgsBuilder internal constructor() {
    private var actionsRequired: Output<Either<String, ActionsRequired>>? = null

    private var description: Output<String>? = null

    private var status: Output<Either<String, PrivateEndpointServiceConnectionStatus>>? = null

    /**
     * @param value A message indicating if changes on the service provider require any updates on the consumer.
     */
    @JvmName("dexykdofkciskdxu")
    public suspend fun actionsRequired(`value`: Output<Either<String, ActionsRequired>>) {
        this.actionsRequired = value
    }

    /**
     * @param value The reason for approval or rejection.
     */
    @JvmName("eylsniiyimrvfrve")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Indicates whether the connection has been approved, rejected or removed by the key vault owner.
     */
    @JvmName("bbxmnryxstmccpfq")
    public suspend
    fun status(`value`: Output<Either<String, PrivateEndpointServiceConnectionStatus>>) {
        this.status = value
    }

    /**
     * @param value A message indicating if changes on the service provider require any updates on the consumer.
     */
    @JvmName("coenekuvkkjvxchx")
    public suspend fun actionsRequired(`value`: Either<String, ActionsRequired>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionsRequired = mapped
    }

    /**
     * @param value A message indicating if changes on the service provider require any updates on the consumer.
     */
    @JvmName("ykhtbqomaieiuhlu")
    public fun actionsRequired(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActionsRequired>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actionsRequired = mapped
    }

    /**
     * @param value A message indicating if changes on the service provider require any updates on the consumer.
     */
    @JvmName("saefuolskftbqthl")
    public fun actionsRequired(`value`: ActionsRequired) {
        val toBeMapped = Either.ofRight<String, ActionsRequired>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actionsRequired = mapped
    }

    /**
     * @param value The reason for approval or rejection.
     */
    @JvmName("oioeiankurjctwaj")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Indicates whether the connection has been approved, rejected or removed by the key vault owner.
     */
    @JvmName("ulwwnckghgagufwf")
    public suspend fun status(`value`: Either<String, PrivateEndpointServiceConnectionStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Indicates whether the connection has been approved, rejected or removed by the key vault owner.
     */
    @JvmName("mdiyfuqmbnwsybrp")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PrivateEndpointServiceConnectionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Indicates whether the connection has been approved, rejected or removed by the key vault owner.
     */
    @JvmName("alkbuvkwdxvtachy")
    public fun status(`value`: PrivateEndpointServiceConnectionStatus) {
        val toBeMapped = Either.ofRight<String, PrivateEndpointServiceConnectionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): MHSMPrivateLinkServiceConnectionStateArgs =
        MHSMPrivateLinkServiceConnectionStateArgs(
            actionsRequired = actionsRequired,
            description = description,
            status = status,
        )
}
