@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.inputs

import com.pulumi.azurenative.keyvault.inputs.NetworkRuleSetArgs.builder
import com.pulumi.azurenative.keyvault.kotlin.enums.NetworkRuleAction
import com.pulumi.azurenative.keyvault.kotlin.enums.NetworkRuleBypassOptions
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A set of rules governing the network accessibility of a vault.
 * @property bypass Tells what traffic can bypass network rules. This can be 'AzureServices' or 'None'.  If not specified the default is 'AzureServices'.
 * @property defaultAction The default action when no rule from ipRules and from virtualNetworkRules match. This is only used after the bypass property has been evaluated.
 * @property ipRules The list of IP address rules.
 * @property virtualNetworkRules The list of virtual network rules.
 */
public data class NetworkRuleSetArgs(
    public val bypass: Output<Either<String, NetworkRuleBypassOptions>>? = null,
    public val defaultAction: Output<Either<String, NetworkRuleAction>>? = null,
    public val ipRules: Output<List<IPRuleArgs>>? = null,
    public val virtualNetworkRules: Output<List<VirtualNetworkRuleArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.keyvault.inputs.NetworkRuleSetArgs> {
    override fun toJava(): com.pulumi.azurenative.keyvault.inputs.NetworkRuleSetArgs =
        com.pulumi.azurenative.keyvault.inputs.NetworkRuleSetArgs.builder()
            .bypass(
                bypass?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .defaultAction(
                defaultAction?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .ipRules(
                ipRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .virtualNetworkRules(
                virtualNetworkRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [NetworkRuleSetArgs].
 */
@PulumiTagMarker
public class NetworkRuleSetArgsBuilder internal constructor() {
    private var bypass: Output<Either<String, NetworkRuleBypassOptions>>? = null

    private var defaultAction: Output<Either<String, NetworkRuleAction>>? = null

    private var ipRules: Output<List<IPRuleArgs>>? = null

    private var virtualNetworkRules: Output<List<VirtualNetworkRuleArgs>>? = null

    /**
     * @param value Tells what traffic can bypass network rules. This can be 'AzureServices' or 'None'.  If not specified the default is 'AzureServices'.
     */
    @JvmName("biioqmfaxvsddgfr")
    public suspend fun bypass(`value`: Output<Either<String, NetworkRuleBypassOptions>>) {
        this.bypass = value
    }

    /**
     * @param value The default action when no rule from ipRules and from virtualNetworkRules match. This is only used after the bypass property has been evaluated.
     */
    @JvmName("yxnckiluaqdqhceb")
    public suspend fun defaultAction(`value`: Output<Either<String, NetworkRuleAction>>) {
        this.defaultAction = value
    }

    /**
     * @param value The list of IP address rules.
     */
    @JvmName("ipqccrhffdycfsdo")
    public suspend fun ipRules(`value`: Output<List<IPRuleArgs>>) {
        this.ipRules = value
    }

    @JvmName("juhyvvbxhimjrmdd")
    public suspend fun ipRules(vararg values: Output<IPRuleArgs>) {
        this.ipRules = Output.all(values.asList())
    }

    /**
     * @param values The list of IP address rules.
     */
    @JvmName("foywcetjlmrxrywf")
    public suspend fun ipRules(values: List<Output<IPRuleArgs>>) {
        this.ipRules = Output.all(values)
    }

    /**
     * @param value The list of virtual network rules.
     */
    @JvmName("lhkcliipcvddingi")
    public suspend fun virtualNetworkRules(`value`: Output<List<VirtualNetworkRuleArgs>>) {
        this.virtualNetworkRules = value
    }

    @JvmName("bmfvgowlufpekskj")
    public suspend fun virtualNetworkRules(vararg values: Output<VirtualNetworkRuleArgs>) {
        this.virtualNetworkRules = Output.all(values.asList())
    }

    /**
     * @param values The list of virtual network rules.
     */
    @JvmName("vvxvpqquajrgsefs")
    public suspend fun virtualNetworkRules(values: List<Output<VirtualNetworkRuleArgs>>) {
        this.virtualNetworkRules = Output.all(values)
    }

    /**
     * @param value Tells what traffic can bypass network rules. This can be 'AzureServices' or 'None'.  If not specified the default is 'AzureServices'.
     */
    @JvmName("kstwmslutggdoewx")
    public suspend fun bypass(`value`: Either<String, NetworkRuleBypassOptions>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bypass = mapped
    }

    /**
     * @param value Tells what traffic can bypass network rules. This can be 'AzureServices' or 'None'.  If not specified the default is 'AzureServices'.
     */
    @JvmName("pgaqnfnpuutxoywl")
    public fun bypass(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NetworkRuleBypassOptions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bypass = mapped
    }

    /**
     * @param value Tells what traffic can bypass network rules. This can be 'AzureServices' or 'None'.  If not specified the default is 'AzureServices'.
     */
    @JvmName("xkwuasqryrnwrbph")
    public fun bypass(`value`: NetworkRuleBypassOptions) {
        val toBeMapped = Either.ofRight<String, NetworkRuleBypassOptions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bypass = mapped
    }

    /**
     * @param value The default action when no rule from ipRules and from virtualNetworkRules match. This is only used after the bypass property has been evaluated.
     */
    @JvmName("vkdkqsdoqljadvsg")
    public suspend fun defaultAction(`value`: Either<String, NetworkRuleAction>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultAction = mapped
    }

    /**
     * @param value The default action when no rule from ipRules and from virtualNetworkRules match. This is only used after the bypass property has been evaluated.
     */
    @JvmName("jlurmldiladyhvxd")
    public fun defaultAction(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NetworkRuleAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultAction = mapped
    }

    /**
     * @param value The default action when no rule from ipRules and from virtualNetworkRules match. This is only used after the bypass property has been evaluated.
     */
    @JvmName("ncnevwghdbgcxcbn")
    public fun defaultAction(`value`: NetworkRuleAction) {
        val toBeMapped = Either.ofRight<String, NetworkRuleAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultAction = mapped
    }

    /**
     * @param value The list of IP address rules.
     */
    @JvmName("hxjfdywaqvnhviyc")
    public suspend fun ipRules(`value`: List<IPRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipRules = mapped
    }

    /**
     * @param argument The list of IP address rules.
     */
    @JvmName("pkrmbxkdkedytfuy")
    public suspend fun ipRules(argument: List<suspend IPRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { IPRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipRules = mapped
    }

    /**
     * @param argument The list of IP address rules.
     */
    @JvmName("tmiuqjledspgatxv")
    public suspend fun ipRules(vararg argument: suspend IPRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { IPRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipRules = mapped
    }

    /**
     * @param argument The list of IP address rules.
     */
    @JvmName("upwbwdkvqnygoknx")
    public suspend fun ipRules(argument: suspend IPRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IPRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipRules = mapped
    }

    /**
     * @param values The list of IP address rules.
     */
    @JvmName("ahdtyhrgatvnqcnc")
    public suspend fun ipRules(vararg values: IPRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipRules = mapped
    }

    /**
     * @param value The list of virtual network rules.
     */
    @JvmName("oxnkwwbicwljatyx")
    public suspend fun virtualNetworkRules(`value`: List<VirtualNetworkRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkRules = mapped
    }

    /**
     * @param argument The list of virtual network rules.
     */
    @JvmName("lxobymhkoiypirwa")
    public suspend
    fun virtualNetworkRules(argument: List<suspend VirtualNetworkRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualNetworkRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.virtualNetworkRules = mapped
    }

    /**
     * @param argument The list of virtual network rules.
     */
    @JvmName("kbbynmegiyoirhgg")
    public suspend fun virtualNetworkRules(
        vararg
        argument: suspend VirtualNetworkRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VirtualNetworkRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.virtualNetworkRules = mapped
    }

    /**
     * @param argument The list of virtual network rules.
     */
    @JvmName("kjmidefqtxduiupt")
    public suspend
    fun virtualNetworkRules(argument: suspend VirtualNetworkRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VirtualNetworkRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.virtualNetworkRules = mapped
    }

    /**
     * @param values The list of virtual network rules.
     */
    @JvmName("utuwpufvedgkbiqj")
    public suspend fun virtualNetworkRules(vararg values: VirtualNetworkRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualNetworkRules = mapped
    }

    internal fun build(): NetworkRuleSetArgs = NetworkRuleSetArgs(
        bypass = bypass,
        defaultAction = defaultAction,
        ipRules = ipRules,
        virtualNetworkRules = virtualNetworkRules,
    )
}
