@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.inputs

import com.pulumi.azurenative.keyvault.inputs.SkuArgs.builder
import com.pulumi.azurenative.keyvault.kotlin.enums.SkuFamily
import com.pulumi.azurenative.keyvault.kotlin.enums.SkuName
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * SKU details
 * @property family SKU family name
 * @property name SKU name to specify whether the key vault is a standard vault or a premium vault.
 */
public data class SkuArgs(
    public val family: Output<Either<String, SkuFamily>>,
    public val name: Output<SkuName>,
) : ConvertibleToJava<com.pulumi.azurenative.keyvault.inputs.SkuArgs> {
    override fun toJava(): com.pulumi.azurenative.keyvault.inputs.SkuArgs =
        com.pulumi.azurenative.keyvault.inputs.SkuArgs.builder()
            .family(
                family.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .name(name.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [SkuArgs].
 */
@PulumiTagMarker
public class SkuArgsBuilder internal constructor() {
    private var family: Output<Either<String, SkuFamily>>? = null

    private var name: Output<SkuName>? = null

    /**
     * @param value SKU family name
     */
    @JvmName("ccwasepbmcfcsihf")
    public suspend fun family(`value`: Output<Either<String, SkuFamily>>) {
        this.family = value
    }

    /**
     * @param value SKU name to specify whether the key vault is a standard vault or a premium vault.
     */
    @JvmName("yypqhdrqoarbwavg")
    public suspend fun name(`value`: Output<SkuName>) {
        this.name = value
    }

    /**
     * @param value SKU family name
     */
    @JvmName("intekxbdwqaxshvu")
    public suspend fun family(`value`: Either<String, SkuFamily>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.family = mapped
    }

    /**
     * @param value SKU family name
     */
    @JvmName("msjuhfpwtcemtinc")
    public fun family(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SkuFamily>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.family = mapped
    }

    /**
     * @param value SKU family name
     */
    @JvmName("ncmaucqqunteickw")
    public fun family(`value`: SkuFamily) {
        val toBeMapped = Either.ofRight<String, SkuFamily>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.family = mapped
    }

    /**
     * @param value SKU name to specify whether the key vault is a standard vault or a premium vault.
     */
    @JvmName("pasiopjxapsimqnb")
    public suspend fun name(`value`: SkuName) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): SkuArgs = SkuArgs(
        family = family ?: throw PulumiNullFieldException("family"),
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
