@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property created Creation time in seconds since 1970-01-01T00:00:00Z.
 * @property expiryTime The expiration time for the new key version. It should be in ISO8601 format. Eg: 'P90D', 'P1Y'.
 * @property updated Last updated time in seconds since 1970-01-01T00:00:00Z.
 */
public data class KeyRotationPolicyAttributesResponse(
    public val created: Double,
    public val expiryTime: String? = null,
    public val updated: Double,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.keyvault.outputs.KeyRotationPolicyAttributesResponse):
            KeyRotationPolicyAttributesResponse = KeyRotationPolicyAttributesResponse(
            created = javaType.created(),
            expiryTime = javaType.expiryTime().map({ args0 -> args0 }).orElse(null),
            updated = javaType.updated(),
        )
    }
}
