@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A rule governing the accessibility of a managed HSM pool from a specific IP address or IP range.
 * @property value An IPv4 address range in CIDR notation, such as '124.56.78.91' (simple IP address) or '124.56.78.0/24' (all addresses that start with 124.56.78).
 */
public data class MHSMIPRuleResponse(
    public val `value`: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.keyvault.outputs.MHSMIPRuleResponse):
            MHSMIPRuleResponse = MHSMIPRuleResponse(
            `value` = javaType.`value`(),
        )
    }
}
