@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Private endpoint connection item.
 * @property etag Modified whenever there is a change in the state of private endpoint connection.
 * @property id Id of private endpoint connection.
 * @property privateEndpoint Properties of the private endpoint object.
 * @property privateLinkServiceConnectionState Approval state of the private link connection.
 * @property provisioningState Provisioning state of the private endpoint connection.
 */
public data class PrivateEndpointConnectionItemResponse(
    public val etag: String? = null,
    public val id: String? = null,
    public val privateEndpoint: PrivateEndpointResponse? = null,
    public val privateLinkServiceConnectionState: PrivateLinkServiceConnectionStateResponse? = null,
    public val provisioningState: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.keyvault.outputs.PrivateEndpointConnectionItemResponse):
            PrivateEndpointConnectionItemResponse = PrivateEndpointConnectionItemResponse(
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            privateEndpoint = javaType.privateEndpoint().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.keyvault.kotlin.outputs.PrivateEndpointResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            privateLinkServiceConnectionState = javaType.privateLinkServiceConnectionState().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.keyvault.kotlin.outputs.PrivateLinkServiceConnectionStateResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
        )
    }
}
