@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetes.kotlin

import com.pulumi.azurenative.kubernetes.KubernetesFunctions.getConnectedClusterPlain
import com.pulumi.azurenative.kubernetes.KubernetesFunctions.listConnectedClusterUserCredentialPlain
import com.pulumi.azurenative.kubernetes.KubernetesFunctions.listConnectedClusterUserCredentialsPlain
import com.pulumi.azurenative.kubernetes.kotlin.enums.AuthenticationMethod
import com.pulumi.azurenative.kubernetes.kotlin.inputs.GetConnectedClusterPlainArgs
import com.pulumi.azurenative.kubernetes.kotlin.inputs.GetConnectedClusterPlainArgsBuilder
import com.pulumi.azurenative.kubernetes.kotlin.inputs.ListConnectedClusterUserCredentialPlainArgs
import com.pulumi.azurenative.kubernetes.kotlin.inputs.ListConnectedClusterUserCredentialPlainArgsBuilder
import com.pulumi.azurenative.kubernetes.kotlin.inputs.ListConnectedClusterUserCredentialsPlainArgs
import com.pulumi.azurenative.kubernetes.kotlin.inputs.ListConnectedClusterUserCredentialsPlainArgsBuilder
import com.pulumi.azurenative.kubernetes.kotlin.outputs.GetConnectedClusterResult
import com.pulumi.azurenative.kubernetes.kotlin.outputs.ListConnectedClusterUserCredentialResult
import com.pulumi.azurenative.kubernetes.kotlin.outputs.ListConnectedClusterUserCredentialsResult
import com.pulumi.core.Either
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.kubernetes.kotlin.outputs.GetConnectedClusterResult.Companion.toKotlin as getConnectedClusterResultToKotlin
import com.pulumi.azurenative.kubernetes.kotlin.outputs.ListConnectedClusterUserCredentialResult.Companion.toKotlin as listConnectedClusterUserCredentialResultToKotlin
import com.pulumi.azurenative.kubernetes.kotlin.outputs.ListConnectedClusterUserCredentialsResult.Companion.toKotlin as listConnectedClusterUserCredentialsResultToKotlin

public object KubernetesFunctions {
    /**
     * Returns the properties of the specified connected cluster, including name, identity, properties, and additional cluster details.
     * Azure REST API version: 2022-05-01-preview.
     * Other available API versions: 2020-01-01-preview, 2022-10-01-preview, 2023-11-01-preview, 2024-01-01, 2024-02-01-preview.
     * @param argument null
     * @return Represents a connected cluster.
     */
    public suspend fun getConnectedCluster(argument: GetConnectedClusterPlainArgs):
        GetConnectedClusterResult =
        getConnectedClusterResultToKotlin(getConnectedClusterPlain(argument.toJava()).await())

    /**
     * @see [getConnectedCluster].
     * @param clusterName The name of the Kubernetes cluster on which get is called.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Represents a connected cluster.
     */
    public suspend fun getConnectedCluster(clusterName: String, resourceGroupName: String):
        GetConnectedClusterResult {
        val argument = GetConnectedClusterPlainArgs(
            clusterName = clusterName,
            resourceGroupName = resourceGroupName,
        )
        return getConnectedClusterResultToKotlin(getConnectedClusterPlain(argument.toJava()).await())
    }

    /**
     * @see [getConnectedCluster].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;kubernetes&#46;kotlin&#46;inputs&#46;GetConnectedClusterPlainArgs].
     * @return Represents a connected cluster.
     */
    public suspend
    fun getConnectedCluster(argument: suspend GetConnectedClusterPlainArgsBuilder.() -> Unit):
        GetConnectedClusterResult {
        val builder = GetConnectedClusterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConnectedClusterResultToKotlin(getConnectedClusterPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets cluster user credentials of the connected cluster with a specified resource group and name.
     * Azure REST API version: 2022-05-01-preview.
     * Other available API versions: 2022-10-01-preview, 2023-11-01-preview, 2024-01-01, 2024-02-01-preview.
     * @param argument null
     * @return The list of credential result response.
     */
    public suspend
    fun listConnectedClusterUserCredential(argument: ListConnectedClusterUserCredentialPlainArgs):
        ListConnectedClusterUserCredentialResult =
        listConnectedClusterUserCredentialResultToKotlin(listConnectedClusterUserCredentialPlain(argument.toJava()).await())

    /**
     * @see [listConnectedClusterUserCredential].
     * @param authenticationMethod The mode of client authentication.
     * @param clientProxy Boolean value to indicate whether the request is for client side proxy or not
     * @param clusterName The name of the Kubernetes cluster on which get is called.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The list of credential result response.
     */
    public suspend fun listConnectedClusterUserCredential(
        authenticationMethod: Either<String, AuthenticationMethod>,
        clientProxy: Boolean,
        clusterName: String,
        resourceGroupName: String,
    ): ListConnectedClusterUserCredentialResult {
        val argument = ListConnectedClusterUserCredentialPlainArgs(
            authenticationMethod = authenticationMethod,
            clientProxy = clientProxy,
            clusterName = clusterName,
            resourceGroupName = resourceGroupName,
        )
        return listConnectedClusterUserCredentialResultToKotlin(listConnectedClusterUserCredentialPlain(argument.toJava()).await())
    }

    /**
     * @see [listConnectedClusterUserCredential].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;kubernetes&#46;kotlin&#46;inputs&#46;ListConnectedClusterUserCredentialPlainArgs].
     * @return The list of credential result response.
     */
    public suspend
    fun listConnectedClusterUserCredential(argument: suspend ListConnectedClusterUserCredentialPlainArgsBuilder.() -> Unit):
        ListConnectedClusterUserCredentialResult {
        val builder = ListConnectedClusterUserCredentialPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listConnectedClusterUserCredentialResultToKotlin(listConnectedClusterUserCredentialPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets cluster user credentials of the connected cluster with a specified resource group and name.
     * Azure REST API version: 2021-04-01-preview.
     * Other available API versions: 2020-01-01-preview.
     * @param argument null
     * @return The list of credential result response.
     */
    public suspend
    fun listConnectedClusterUserCredentials(argument: ListConnectedClusterUserCredentialsPlainArgs):
        ListConnectedClusterUserCredentialsResult =
        listConnectedClusterUserCredentialsResultToKotlin(listConnectedClusterUserCredentialsPlain(argument.toJava()).await())

    /**
     * @see [listConnectedClusterUserCredentials].
     * @param authenticationMethod The mode of client authentication.
     * @param clientProxy Boolean value to indicate whether the request is for client side proxy or not
     * @param clusterName The name of the Kubernetes cluster on which get is called.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The list of credential result response.
     */
    public suspend fun listConnectedClusterUserCredentials(
        authenticationMethod: Either<String, AuthenticationMethod>,
        clientProxy: Boolean,
        clusterName: String,
        resourceGroupName: String,
    ): ListConnectedClusterUserCredentialsResult {
        val argument = ListConnectedClusterUserCredentialsPlainArgs(
            authenticationMethod = authenticationMethod,
            clientProxy = clientProxy,
            clusterName = clusterName,
            resourceGroupName = resourceGroupName,
        )
        return listConnectedClusterUserCredentialsResultToKotlin(listConnectedClusterUserCredentialsPlain(argument.toJava()).await())
    }

    /**
     * @see [listConnectedClusterUserCredentials].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;kubernetes&#46;kotlin&#46;inputs&#46;ListConnectedClusterUserCredentialsPlainArgs].
     * @return The list of credential result response.
     */
    public suspend
    fun listConnectedClusterUserCredentials(argument: suspend ListConnectedClusterUserCredentialsPlainArgsBuilder.() -> Unit):
        ListConnectedClusterUserCredentialsResult {
        val builder = ListConnectedClusterUserCredentialsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listConnectedClusterUserCredentialsResultToKotlin(listConnectedClusterUserCredentialsPlain(builtArgument.toJava()).await())
    }
}
