@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetes.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Provisioning state of the connected cluster resource.
 */
public enum class ProvisioningState(
    public val javaValue: com.pulumi.azurenative.kubernetes.enums.ProvisioningState,
) : ConvertibleToJava<com.pulumi.azurenative.kubernetes.enums.ProvisioningState> {
    Succeeded(com.pulumi.azurenative.kubernetes.enums.ProvisioningState.Succeeded),
    Failed(com.pulumi.azurenative.kubernetes.enums.ProvisioningState.Failed),
    Canceled(com.pulumi.azurenative.kubernetes.enums.ProvisioningState.Canceled),
    Provisioning(com.pulumi.azurenative.kubernetes.enums.ProvisioningState.Provisioning),
    Updating(com.pulumi.azurenative.kubernetes.enums.ProvisioningState.Updating),
    Deleting(com.pulumi.azurenative.kubernetes.enums.ProvisioningState.Deleting),
    Accepted(com.pulumi.azurenative.kubernetes.enums.ProvisioningState.Accepted),
    ;

    override fun toJava(): com.pulumi.azurenative.kubernetes.enums.ProvisioningState = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kubernetes.enums.ProvisioningState):
            ProvisioningState = ProvisioningState.values().first { it.javaValue == javaType }
    }
}
