@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin

import com.pulumi.azurenative.kubernetesconfiguration.PrivateEndpointConnectionArgs.builder
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs.PrivateLinkServiceConnectionStateArgs
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs.PrivateLinkServiceConnectionStateArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The Private Endpoint Connection resource.
 * Azure REST API version: 2022-04-02-preview. Prior API version in Azure Native 1.x: 2022-04-02-preview.
 * ## Example Usage
 * ### Approve or reject a private endpoint connection with a given name.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnection = new AzureNative.KubernetesConfiguration.PrivateEndpointConnection("privateEndpointConnection", new()
 *     {
 *         PrivateEndpointConnectionName = "private-endpoint-connection-name",
 *         PrivateLinkServiceConnectionState = new AzureNative.KubernetesConfiguration.Inputs.PrivateLinkServiceConnectionStateArgs
 *         {
 *             Description = "Approved by johndoe@contoso.com",
 *             Status = "Approved",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ScopeName = "myPrivateLinkScope",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kubernetesconfiguration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kubernetesconfiguration.NewPrivateEndpointConnection(ctx, "privateEndpointConnection", &kubernetesconfiguration.PrivateEndpointConnectionArgs{
 * 			PrivateEndpointConnectionName: pulumi.String("private-endpoint-connection-name"),
 * 			PrivateLinkServiceConnectionState: &kubernetesconfiguration.PrivateLinkServiceConnectionStateArgs{
 * 				Description: pulumi.String("Approved by johndoe@contoso.com"),
 * 				Status:      pulumi.String("Approved"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ScopeName:         pulumi.String("myPrivateLinkScope"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kubernetesconfiguration.PrivateEndpointConnection;
 * import com.pulumi.azurenative.kubernetesconfiguration.PrivateEndpointConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnection = new PrivateEndpointConnection("privateEndpointConnection", PrivateEndpointConnectionArgs.builder()
 *             .privateEndpointConnectionName("private-endpoint-connection-name")
 *             .privateLinkServiceConnectionState(Map.ofEntries(
 *                 Map.entry("description", "Approved by johndoe@contoso.com"),
 *                 Map.entry("status", "Approved")
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .scopeName("myPrivateLinkScope")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:kubernetesconfiguration:PrivateEndpointConnection private-endpoint-connection-name /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KubernetesConfiguration/privateLinkScopes/{scopeName}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 * @property privateEndpointConnectionName The name of the private endpoint connection associated with the Azure resource
 * @property privateLinkServiceConnectionState A collection of information about the state of the connection between service consumer and provider.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property scopeName The name of the Azure Arc PrivateLinkScope resource.
 */
public data class PrivateEndpointConnectionArgs(
    public val privateEndpointConnectionName: Output<String>? = null,
    public val privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null,
    public val resourceGroupName: Output<String>? = null,
    public val scopeName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.kubernetesconfiguration.PrivateEndpointConnectionArgs> {
    override fun toJava():
        com.pulumi.azurenative.kubernetesconfiguration.PrivateEndpointConnectionArgs =
        com.pulumi.azurenative.kubernetesconfiguration.PrivateEndpointConnectionArgs.builder()
            .privateEndpointConnectionName(privateEndpointConnectionName?.applyValue({ args0 -> args0 }))
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scopeName(scopeName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateEndpointConnectionArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionArgsBuilder internal constructor() {
    private var privateEndpointConnectionName: Output<String>? = null

    private var privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null

    private var resourceGroupName: Output<String>? = null

    private var scopeName: Output<String>? = null

    /**
     * @param value The name of the private endpoint connection associated with the Azure resource
     */
    @JvmName("orixeoitdgmgpwbl")
    public suspend fun privateEndpointConnectionName(`value`: Output<String>) {
        this.privateEndpointConnectionName = value
    }

    /**
     * @param value A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("augqjfovyxvsgmno")
    public suspend
    fun privateLinkServiceConnectionState(`value`: Output<PrivateLinkServiceConnectionStateArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dojfuiahlbharleo")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Azure Arc PrivateLinkScope resource.
     */
    @JvmName("hexnmcmqepvrtlgv")
    public suspend fun scopeName(`value`: Output<String>) {
        this.scopeName = value
    }

    /**
     * @param value The name of the private endpoint connection associated with the Azure resource
     */
    @JvmName("fqveyohhdcyxwwtg")
    public suspend fun privateEndpointConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("hdwuowhejxuhofhl")
    public suspend
    fun privateLinkServiceConnectionState(`value`: PrivateLinkServiceConnectionStateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("dvubpkamaabfaxpj")
    public suspend
    fun privateLinkServiceConnectionState(argument: suspend PrivateLinkServiceConnectionStateArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateLinkServiceConnectionStateArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("alpvojadlffrynie")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Azure Arc PrivateLinkScope resource.
     */
    @JvmName("mlhepixouskbwncn")
    public suspend fun scopeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scopeName = mapped
    }

    internal fun build(): PrivateEndpointConnectionArgs = PrivateEndpointConnectionArgs(
        privateEndpointConnectionName = privateEndpointConnectionName,
        privateLinkServiceConnectionState = privateLinkServiceConnectionState,
        resourceGroupName = resourceGroupName,
        scopeName = scopeName,
    )
}
