@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin

import com.pulumi.azurenative.kubernetesconfiguration.PrivateLinkScopeArgs.builder
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs.KubernetesConfigurationPrivateLinkScopePropertiesArgs
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs.KubernetesConfigurationPrivateLinkScopePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An Azure Arc PrivateLinkScope definition.
 * Azure REST API version: 2022-04-02-preview. Prior API version in Azure Native 1.x: 2022-04-02-preview.
 * ## Example Usage
 * ### PrivateLinkScopeCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateLinkScope = new AzureNative.KubernetesConfiguration.PrivateLinkScope("privateLinkScope", new()
 *     {
 *         Location = "westus",
 *         ResourceGroupName = "my-resource-group",
 *         ScopeName = "my-privatelinkscope",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kubernetesconfiguration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kubernetesconfiguration.NewPrivateLinkScope(ctx, "privateLinkScope", &kubernetesconfiguration.PrivateLinkScopeArgs{
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("my-resource-group"),
 * 			ScopeName:         pulumi.String("my-privatelinkscope"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kubernetesconfiguration.PrivateLinkScope;
 * import com.pulumi.azurenative.kubernetesconfiguration.PrivateLinkScopeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateLinkScope = new PrivateLinkScope("privateLinkScope", PrivateLinkScopeArgs.builder()
 *             .location("westus")
 *             .resourceGroupName("my-resource-group")
 *             .scopeName("my-privatelinkscope")
 *             .build());
 *     }
 * }
 * ```
 * ### PrivateLinkScopeUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateLinkScope = new AzureNative.KubernetesConfiguration.PrivateLinkScope("privateLinkScope", new()
 *     {
 *         Location = "westus",
 *         ResourceGroupName = "my-resource-group",
 *         ScopeName = "my-privatelinkscope",
 *         Tags =
 *         {
 *             { "Tag1", "Value1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kubernetesconfiguration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kubernetesconfiguration.NewPrivateLinkScope(ctx, "privateLinkScope", &kubernetesconfiguration.PrivateLinkScopeArgs{
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("my-resource-group"),
 * 			ScopeName:         pulumi.String("my-privatelinkscope"),
 * 			Tags: pulumi.StringMap{
 * 				"Tag1": pulumi.String("Value1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kubernetesconfiguration.PrivateLinkScope;
 * import com.pulumi.azurenative.kubernetesconfiguration.PrivateLinkScopeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateLinkScope = new PrivateLinkScope("privateLinkScope", PrivateLinkScopeArgs.builder()
 *             .location("westus")
 *             .resourceGroupName("my-resource-group")
 *             .scopeName("my-privatelinkscope")
 *             .tags(Map.of("Tag1", "Value1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:kubernetesconfiguration:PrivateLinkScope my-privatelinkscope /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KubernetesConfiguration/privateLinkScopes/{scopeName}
 * ```
 * @property location The geo-location where the resource lives
 * @property properties Properties that define a Azure Arc PrivateLinkScope resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property scopeName The name of the Azure Arc PrivateLinkScope resource.
 * @property tags Resource tags.
 */
public data class PrivateLinkScopeArgs(
    public val location: Output<String>? = null,
    public val properties: Output<KubernetesConfigurationPrivateLinkScopePropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scopeName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.kubernetesconfiguration.PrivateLinkScopeArgs> {
    override fun toJava(): com.pulumi.azurenative.kubernetesconfiguration.PrivateLinkScopeArgs =
        com.pulumi.azurenative.kubernetesconfiguration.PrivateLinkScopeArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scopeName(scopeName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PrivateLinkScopeArgs].
 */
@PulumiTagMarker
public class PrivateLinkScopeArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var properties: Output<KubernetesConfigurationPrivateLinkScopePropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var scopeName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("jpswsbrfciildslk")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Properties that define a Azure Arc PrivateLinkScope resource.
     */
    @JvmName("qtyyjmkyboikjrwj")
    public suspend
    fun properties(`value`: Output<KubernetesConfigurationPrivateLinkScopePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kuirtningtxjdqpn")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Azure Arc PrivateLinkScope resource.
     */
    @JvmName("uawoeuhmgkpcvtqr")
    public suspend fun scopeName(`value`: Output<String>) {
        this.scopeName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("hgoqvuqdtxfeojeq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("jkyidwfpcydpedlr")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Properties that define a Azure Arc PrivateLinkScope resource.
     */
    @JvmName("kvyvatfldxucsvmu")
    public suspend fun properties(`value`: KubernetesConfigurationPrivateLinkScopePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties that define a Azure Arc PrivateLinkScope resource.
     */
    @JvmName("rhsenejrytokxpxi")
    public suspend
    fun properties(argument: suspend KubernetesConfigurationPrivateLinkScopePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = KubernetesConfigurationPrivateLinkScopePropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("uugtkcjoyektcall")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Azure Arc PrivateLinkScope resource.
     */
    @JvmName("frnxconxtxkotuar")
    public suspend fun scopeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scopeName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("juymlxlfgfwurnlh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("rcakbmchhllsupce")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PrivateLinkScopeArgs = PrivateLinkScopeArgs(
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        scopeName = scopeName,
        tags = tags,
    )
}
