@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs

import com.pulumi.azurenative.kubernetesconfiguration.inputs.BucketDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Parameters to reconcile to the Bucket source kind type.
 * @property accessKey Plaintext access key used to securely access the S3 bucket
 * @property bucketName The bucket name to sync from the url endpoint for the flux configuration.
 * @property insecure Specify whether to use insecure communication when puling data from the S3 bucket.
 * @property localAuthRef Name of a local secret on the Kubernetes cluster to use as the authentication secret rather than the managed or user-provided configuration secrets.
 * @property syncIntervalInSeconds The interval at which to re-reconcile the cluster bucket source with the remote.
 * @property timeoutInSeconds The maximum time to attempt to reconcile the cluster bucket source with the remote.
 * @property url The URL to sync for the flux configuration S3 bucket.
 */
public data class BucketDefinitionArgs(
    public val accessKey: Output<String>? = null,
    public val bucketName: Output<String>? = null,
    public val insecure: Output<Boolean>? = null,
    public val localAuthRef: Output<String>? = null,
    public val syncIntervalInSeconds: Output<Double>? = null,
    public val timeoutInSeconds: Output<Double>? = null,
    public val url: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.kubernetesconfiguration.inputs.BucketDefinitionArgs> {
    override fun toJava(): com.pulumi.azurenative.kubernetesconfiguration.inputs.BucketDefinitionArgs =
        com.pulumi.azurenative.kubernetesconfiguration.inputs.BucketDefinitionArgs.builder()
            .accessKey(accessKey?.applyValue({ args0 -> args0 }))
            .bucketName(bucketName?.applyValue({ args0 -> args0 }))
            .insecure(insecure?.applyValue({ args0 -> args0 }))
            .localAuthRef(localAuthRef?.applyValue({ args0 -> args0 }))
            .syncIntervalInSeconds(syncIntervalInSeconds?.applyValue({ args0 -> args0 }))
            .timeoutInSeconds(timeoutInSeconds?.applyValue({ args0 -> args0 }))
            .url(url?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketDefinitionArgs].
 */
@PulumiTagMarker
public class BucketDefinitionArgsBuilder internal constructor() {
    private var accessKey: Output<String>? = null

    private var bucketName: Output<String>? = null

    private var insecure: Output<Boolean>? = null

    private var localAuthRef: Output<String>? = null

    private var syncIntervalInSeconds: Output<Double>? = null

    private var timeoutInSeconds: Output<Double>? = null

    private var url: Output<String>? = null

    /**
     * @param value Plaintext access key used to securely access the S3 bucket
     */
    @JvmName("nxaofnyeypxwkrqr")
    public suspend fun accessKey(`value`: Output<String>) {
        this.accessKey = value
    }

    /**
     * @param value The bucket name to sync from the url endpoint for the flux configuration.
     */
    @JvmName("avyjdunpwwcfwgah")
    public suspend fun bucketName(`value`: Output<String>) {
        this.bucketName = value
    }

    /**
     * @param value Specify whether to use insecure communication when puling data from the S3 bucket.
     */
    @JvmName("opdhjedaxaknquae")
    public suspend fun insecure(`value`: Output<Boolean>) {
        this.insecure = value
    }

    /**
     * @param value Name of a local secret on the Kubernetes cluster to use as the authentication secret rather than the managed or user-provided configuration secrets.
     */
    @JvmName("xuwlrswdhvtdmeyk")
    public suspend fun localAuthRef(`value`: Output<String>) {
        this.localAuthRef = value
    }

    /**
     * @param value The interval at which to re-reconcile the cluster bucket source with the remote.
     */
    @JvmName("ydmiohpouypfusya")
    public suspend fun syncIntervalInSeconds(`value`: Output<Double>) {
        this.syncIntervalInSeconds = value
    }

    /**
     * @param value The maximum time to attempt to reconcile the cluster bucket source with the remote.
     */
    @JvmName("mridmlngsfguciqx")
    public suspend fun timeoutInSeconds(`value`: Output<Double>) {
        this.timeoutInSeconds = value
    }

    /**
     * @param value The URL to sync for the flux configuration S3 bucket.
     */
    @JvmName("lstfbtfhyfmhimcj")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value Plaintext access key used to securely access the S3 bucket
     */
    @JvmName("qtyqbundxebmyygf")
    public suspend fun accessKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessKey = mapped
    }

    /**
     * @param value The bucket name to sync from the url endpoint for the flux configuration.
     */
    @JvmName("fbyvkauobrlamkvw")
    public suspend fun bucketName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketName = mapped
    }

    /**
     * @param value Specify whether to use insecure communication when puling data from the S3 bucket.
     */
    @JvmName("lkbdsqevnpbiaxco")
    public suspend fun insecure(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.insecure = mapped
    }

    /**
     * @param value Name of a local secret on the Kubernetes cluster to use as the authentication secret rather than the managed or user-provided configuration secrets.
     */
    @JvmName("btqnhsdrnqhpards")
    public suspend fun localAuthRef(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localAuthRef = mapped
    }

    /**
     * @param value The interval at which to re-reconcile the cluster bucket source with the remote.
     */
    @JvmName("iomkqsyaqaslvnlv")
    public suspend fun syncIntervalInSeconds(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.syncIntervalInSeconds = mapped
    }

    /**
     * @param value The maximum time to attempt to reconcile the cluster bucket source with the remote.
     */
    @JvmName("fxbdyvpcqwvguimc")
    public suspend fun timeoutInSeconds(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutInSeconds = mapped
    }

    /**
     * @param value The URL to sync for the flux configuration S3 bucket.
     */
    @JvmName("onswpaxuccbmdjkd")
    public suspend fun url(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.url = mapped
    }

    internal fun build(): BucketDefinitionArgs = BucketDefinitionArgs(
        accessKey = accessKey,
        bucketName = bucketName,
        insecure = insecure,
        localAuthRef = localAuthRef,
        syncIntervalInSeconds = syncIntervalInSeconds,
        timeoutInSeconds = timeoutInSeconds,
        url = url,
    )
}
