@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs

import com.pulumi.azurenative.kubernetesconfiguration.inputs.GitRepositoryDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Parameters to reconcile to the GitRepository source kind type.
 * @property httpsCACert Base64-encoded HTTPS certificate authority contents used to access git private git repositories over HTTPS
 * @property httpsUser Plaintext HTTPS username used to access private git repositories over HTTPS
 * @property localAuthRef Name of a local secret on the Kubernetes cluster to use as the authentication secret rather than the managed or user-provided configuration secrets.
 * @property repositoryRef The source reference for the GitRepository object.
 * @property sshKnownHosts Base64-encoded known_hosts value containing public SSH keys required to access private git repositories over SSH
 * @property syncIntervalInSeconds The interval at which to re-reconcile the cluster git repository source with the remote.
 * @property timeoutInSeconds The maximum time to attempt to reconcile the cluster git repository source with the remote.
 * @property url The URL to sync for the flux configuration git repository.
 */
public data class GitRepositoryDefinitionArgs(
    public val httpsCACert: Output<String>? = null,
    public val httpsUser: Output<String>? = null,
    public val localAuthRef: Output<String>? = null,
    public val repositoryRef: Output<RepositoryRefDefinitionArgs>? = null,
    public val sshKnownHosts: Output<String>? = null,
    public val syncIntervalInSeconds: Output<Double>? = null,
    public val timeoutInSeconds: Output<Double>? = null,
    public val url: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.kubernetesconfiguration.inputs.GitRepositoryDefinitionArgs> {
    override fun toJava():
        com.pulumi.azurenative.kubernetesconfiguration.inputs.GitRepositoryDefinitionArgs =
        com.pulumi.azurenative.kubernetesconfiguration.inputs.GitRepositoryDefinitionArgs.builder()
            .httpsCACert(httpsCACert?.applyValue({ args0 -> args0 }))
            .httpsUser(httpsUser?.applyValue({ args0 -> args0 }))
            .localAuthRef(localAuthRef?.applyValue({ args0 -> args0 }))
            .repositoryRef(repositoryRef?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sshKnownHosts(sshKnownHosts?.applyValue({ args0 -> args0 }))
            .syncIntervalInSeconds(syncIntervalInSeconds?.applyValue({ args0 -> args0 }))
            .timeoutInSeconds(timeoutInSeconds?.applyValue({ args0 -> args0 }))
            .url(url?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GitRepositoryDefinitionArgs].
 */
@PulumiTagMarker
public class GitRepositoryDefinitionArgsBuilder internal constructor() {
    private var httpsCACert: Output<String>? = null

    private var httpsUser: Output<String>? = null

    private var localAuthRef: Output<String>? = null

    private var repositoryRef: Output<RepositoryRefDefinitionArgs>? = null

    private var sshKnownHosts: Output<String>? = null

    private var syncIntervalInSeconds: Output<Double>? = null

    private var timeoutInSeconds: Output<Double>? = null

    private var url: Output<String>? = null

    /**
     * @param value Base64-encoded HTTPS certificate authority contents used to access git private git repositories over HTTPS
     */
    @JvmName("cnmrvtrdiydguamw")
    public suspend fun httpsCACert(`value`: Output<String>) {
        this.httpsCACert = value
    }

    /**
     * @param value Plaintext HTTPS username used to access private git repositories over HTTPS
     */
    @JvmName("tbhiemhovltkbagy")
    public suspend fun httpsUser(`value`: Output<String>) {
        this.httpsUser = value
    }

    /**
     * @param value Name of a local secret on the Kubernetes cluster to use as the authentication secret rather than the managed or user-provided configuration secrets.
     */
    @JvmName("uphduxmbcwhlpeou")
    public suspend fun localAuthRef(`value`: Output<String>) {
        this.localAuthRef = value
    }

    /**
     * @param value The source reference for the GitRepository object.
     */
    @JvmName("bmpoqcuhkpjjnarg")
    public suspend fun repositoryRef(`value`: Output<RepositoryRefDefinitionArgs>) {
        this.repositoryRef = value
    }

    /**
     * @param value Base64-encoded known_hosts value containing public SSH keys required to access private git repositories over SSH
     */
    @JvmName("sdlscybxvgetudwy")
    public suspend fun sshKnownHosts(`value`: Output<String>) {
        this.sshKnownHosts = value
    }

    /**
     * @param value The interval at which to re-reconcile the cluster git repository source with the remote.
     */
    @JvmName("nqrtnphmesarxkyt")
    public suspend fun syncIntervalInSeconds(`value`: Output<Double>) {
        this.syncIntervalInSeconds = value
    }

    /**
     * @param value The maximum time to attempt to reconcile the cluster git repository source with the remote.
     */
    @JvmName("gmlmwtfsgilsfkbm")
    public suspend fun timeoutInSeconds(`value`: Output<Double>) {
        this.timeoutInSeconds = value
    }

    /**
     * @param value The URL to sync for the flux configuration git repository.
     */
    @JvmName("jrmivytsnmekxqjl")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value Base64-encoded HTTPS certificate authority contents used to access git private git repositories over HTTPS
     */
    @JvmName("rdvadpaobynhknbx")
    public suspend fun httpsCACert(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpsCACert = mapped
    }

    /**
     * @param value Plaintext HTTPS username used to access private git repositories over HTTPS
     */
    @JvmName("yukqwoixwcqphqmf")
    public suspend fun httpsUser(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpsUser = mapped
    }

    /**
     * @param value Name of a local secret on the Kubernetes cluster to use as the authentication secret rather than the managed or user-provided configuration secrets.
     */
    @JvmName("fuslxovkdjlikyrt")
    public suspend fun localAuthRef(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localAuthRef = mapped
    }

    /**
     * @param value The source reference for the GitRepository object.
     */
    @JvmName("tiijjxewpkqhrnur")
    public suspend fun repositoryRef(`value`: RepositoryRefDefinitionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repositoryRef = mapped
    }

    /**
     * @param argument The source reference for the GitRepository object.
     */
    @JvmName("eqorwylmtwmodqmr")
    public suspend
    fun repositoryRef(argument: suspend RepositoryRefDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = RepositoryRefDefinitionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.repositoryRef = mapped
    }

    /**
     * @param value Base64-encoded known_hosts value containing public SSH keys required to access private git repositories over SSH
     */
    @JvmName("qcdlppjblubneepr")
    public suspend fun sshKnownHosts(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sshKnownHosts = mapped
    }

    /**
     * @param value The interval at which to re-reconcile the cluster git repository source with the remote.
     */
    @JvmName("ncrrwfbqwwiedhdq")
    public suspend fun syncIntervalInSeconds(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.syncIntervalInSeconds = mapped
    }

    /**
     * @param value The maximum time to attempt to reconcile the cluster git repository source with the remote.
     */
    @JvmName("bagikhlefeubypjj")
    public suspend fun timeoutInSeconds(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutInSeconds = mapped
    }

    /**
     * @param value The URL to sync for the flux configuration git repository.
     */
    @JvmName("ygrujxhnjgneimpd")
    public suspend fun url(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.url = mapped
    }

    internal fun build(): GitRepositoryDefinitionArgs = GitRepositoryDefinitionArgs(
        httpsCACert = httpsCACert,
        httpsUser = httpsUser,
        localAuthRef = localAuthRef,
        repositoryRef = repositoryRef,
        sshKnownHosts = sshKnownHosts,
        syncIntervalInSeconds = syncIntervalInSeconds,
        timeoutInSeconds = timeoutInSeconds,
        url = url,
    )
}
