@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs

import com.pulumi.azurenative.kubernetesconfiguration.inputs.RepositoryRefDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The source reference for the GitRepository object.
 * @property branch The git repository branch name to checkout.
 * @property commit The commit SHA to checkout. This value must be combined with the branch name to be valid. This takes precedence over semver.
 * @property semver The semver range used to match against git repository tags. This takes precedence over tag.
 * @property tag The git repository tag name to checkout. This takes precedence over branch.
 */
public data class RepositoryRefDefinitionArgs(
    public val branch: Output<String>? = null,
    public val commit: Output<String>? = null,
    public val semver: Output<String>? = null,
    public val tag: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.kubernetesconfiguration.inputs.RepositoryRefDefinitionArgs> {
    override fun toJava():
        com.pulumi.azurenative.kubernetesconfiguration.inputs.RepositoryRefDefinitionArgs =
        com.pulumi.azurenative.kubernetesconfiguration.inputs.RepositoryRefDefinitionArgs.builder()
            .branch(branch?.applyValue({ args0 -> args0 }))
            .commit(commit?.applyValue({ args0 -> args0 }))
            .semver(semver?.applyValue({ args0 -> args0 }))
            .tag(tag?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RepositoryRefDefinitionArgs].
 */
@PulumiTagMarker
public class RepositoryRefDefinitionArgsBuilder internal constructor() {
    private var branch: Output<String>? = null

    private var commit: Output<String>? = null

    private var semver: Output<String>? = null

    private var tag: Output<String>? = null

    /**
     * @param value The git repository branch name to checkout.
     */
    @JvmName("kyclbmrbljpaufdw")
    public suspend fun branch(`value`: Output<String>) {
        this.branch = value
    }

    /**
     * @param value The commit SHA to checkout. This value must be combined with the branch name to be valid. This takes precedence over semver.
     */
    @JvmName("sfabjyplpqbpabiw")
    public suspend fun commit(`value`: Output<String>) {
        this.commit = value
    }

    /**
     * @param value The semver range used to match against git repository tags. This takes precedence over tag.
     */
    @JvmName("lswmdaanmrcerxxu")
    public suspend fun semver(`value`: Output<String>) {
        this.semver = value
    }

    /**
     * @param value The git repository tag name to checkout. This takes precedence over branch.
     */
    @JvmName("bqowpjaqiopblcbm")
    public suspend fun tag(`value`: Output<String>) {
        this.tag = value
    }

    /**
     * @param value The git repository branch name to checkout.
     */
    @JvmName("flyljhjspefucdet")
    public suspend fun branch(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.branch = mapped
    }

    /**
     * @param value The commit SHA to checkout. This value must be combined with the branch name to be valid. This takes precedence over semver.
     */
    @JvmName("fceuqmvbosgmhfli")
    public suspend fun commit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commit = mapped
    }

    /**
     * @param value The semver range used to match against git repository tags. This takes precedence over tag.
     */
    @JvmName("jfbwsrblxqmqvkxk")
    public suspend fun semver(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.semver = mapped
    }

    /**
     * @param value The git repository tag name to checkout. This takes precedence over branch.
     */
    @JvmName("fbtllywgjsikuirj")
    public suspend fun tag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tag = mapped
    }

    internal fun build(): RepositoryRefDefinitionArgs = RepositoryRefDefinitionArgs(
        branch = branch,
        commit = commit,
        semver = semver,
        tag = tag,
    )
}
