@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Compliance Status details
 * @property complianceState The compliance state of the configuration.
 * @property lastConfigApplied Datetime the configuration was last applied.
 * @property message Message from when the configuration was applied.
 * @property messageLevel Level of the message.
 */
public data class ComplianceStatusResponse(
    public val complianceState: String,
    public val lastConfigApplied: String? = null,
    public val message: String? = null,
    public val messageLevel: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.kubernetesconfiguration.outputs.ComplianceStatusResponse):
            ComplianceStatusResponse = ComplianceStatusResponse(
            complianceState = javaType.complianceState(),
            lastConfigApplied = javaType.lastConfigApplied().map({ args0 -> args0 }).orElse(null),
            message = javaType.message().map({ args0 -> args0 }).orElse(null),
            messageLevel = javaType.messageLevel().map({ args0 -> args0 }).orElse(null),
        )
    }
}
