@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Object reference to a Kubernetes object on a cluster
 * @property name Name of the object
 * @property namespace Namespace of the object
 */
public data class ObjectReferenceDefinitionResponse(
    public val name: String? = null,
    public val namespace: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.kubernetesconfiguration.outputs.ObjectReferenceDefinitionResponse):
            ObjectReferenceDefinitionResponse = ObjectReferenceDefinitionResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            namespace = javaType.namespace().map({ args0 -> args0 }).orElse(null),
        )
    }
}
