@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Statuses of objects deployed by the user-specified kustomizations from the git repository.
 * @property appliedBy Object reference to the Kustomization that applied this object
 * @property complianceState Compliance state of the applied object showing whether the applied object has come into a ready state on the cluster.
 * @property helmReleaseProperties Additional properties that are provided from objects of the HelmRelease kind
 * @property kind Kind of the applied object
 * @property name Name of the applied object
 * @property namespace Namespace of the applied object
 * @property statusConditions List of Kubernetes object status conditions present on the cluster
 */
public data class ObjectStatusDefinitionResponse(
    public val appliedBy: ObjectReferenceDefinitionResponse? = null,
    public val complianceState: String? = null,
    public val helmReleaseProperties: HelmReleasePropertiesDefinitionResponse? = null,
    public val kind: String? = null,
    public val name: String? = null,
    public val namespace: String? = null,
    public val statusConditions: List<ObjectStatusConditionDefinitionResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.kubernetesconfiguration.outputs.ObjectStatusDefinitionResponse):
            ObjectStatusDefinitionResponse = ObjectStatusDefinitionResponse(
            appliedBy = javaType.appliedBy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.ObjectReferenceDefinitionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            complianceState = javaType.complianceState().map({ args0 -> args0 }).orElse(null),
            helmReleaseProperties = javaType.helmReleaseProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.HelmReleasePropertiesDefinitionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            namespace = javaType.namespace().map({ args0 -> args0 }).orElse(null),
            statusConditions = javaType.statusConditions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.ObjectStatusConditionDefinitionResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
