@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin

import com.pulumi.azurenative.kusto.AttachedDatabaseConfigurationArgs.builder
import com.pulumi.azurenative.kusto.kotlin.enums.DefaultPrincipalsModificationKind
import com.pulumi.azurenative.kusto.kotlin.inputs.TableLevelSharingPropertiesArgs
import com.pulumi.azurenative.kusto.kotlin.inputs.TableLevelSharingPropertiesArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Class representing an attached database configuration.
 * Azure REST API version: 2022-12-29. Prior API version in Azure Native 1.x: 2021-01-01.
 * Other available API versions: 2023-05-02, 2023-08-15.
 * ## Example Usage
 * ### AttachedDatabaseConfigurationsCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var attachedDatabaseConfiguration = new AzureNative.Kusto.AttachedDatabaseConfiguration("attachedDatabaseConfiguration", new()
 *     {
 *         AttachedDatabaseConfigurationName = "attachedDatabaseConfigurationsTest",
 *         ClusterName = "kustoCluster2",
 *         ClusterResourceId = "/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Kusto/Clusters/kustoCluster2",
 *         DatabaseName = "kustodatabase",
 *         DatabaseNameOverride = "overridekustodatabase",
 *         DefaultPrincipalsModificationKind = "Union",
 *         Location = "westus",
 *         ResourceGroupName = "kustorptest",
 *         TableLevelSharingProperties = new AzureNative.Kusto.Inputs.TableLevelSharingPropertiesArgs
 *         {
 *             ExternalTablesToExclude = new[]
 *             {
 *                 "ExternalTable2",
 *             },
 *             ExternalTablesToInclude = new[]
 *             {
 *                 "ExternalTable1",
 *             },
 *             MaterializedViewsToExclude = new[]
 *             {
 *                 "MaterializedViewTable2",
 *             },
 *             MaterializedViewsToInclude = new[]
 *             {
 *                 "MaterializedViewTable1",
 *             },
 *             TablesToExclude = new[]
 *             {
 *                 "Table2",
 *             },
 *             TablesToInclude = new[]
 *             {
 *                 "Table1",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kusto/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kusto.NewAttachedDatabaseConfiguration(ctx, "attachedDatabaseConfiguration", &kusto.AttachedDatabaseConfigurationArgs{
 * 			AttachedDatabaseConfigurationName: pulumi.String("attachedDatabaseConfigurationsTest"),
 * 			ClusterName:                       pulumi.String("kustoCluster2"),
 * 			ClusterResourceId:                 pulumi.String("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Kusto/Clusters/kustoCluster2"),
 * 			DatabaseName:                      pulumi.String("kustodatabase"),
 * 			DatabaseNameOverride:              pulumi.String("overridekustodatabase"),
 * 			DefaultPrincipalsModificationKind: pulumi.String("Union"),
 * 			Location:                          pulumi.String("westus"),
 * 			ResourceGroupName:                 pulumi.String("kustorptest"),
 * 			TableLevelSharingProperties: &kusto.TableLevelSharingPropertiesArgs{
 * 				ExternalTablesToExclude: pulumi.StringArray{
 * 					pulumi.String("ExternalTable2"),
 * 				},
 * 				ExternalTablesToInclude: pulumi.StringArray{
 * 					pulumi.String("ExternalTable1"),
 * 				},
 * 				MaterializedViewsToExclude: pulumi.StringArray{
 * 					pulumi.String("MaterializedViewTable2"),
 * 				},
 * 				MaterializedViewsToInclude: pulumi.StringArray{
 * 					pulumi.String("MaterializedViewTable1"),
 * 				},
 * 				TablesToExclude: pulumi.StringArray{
 * 					pulumi.String("Table2"),
 * 				},
 * 				TablesToInclude: pulumi.StringArray{
 * 					pulumi.String("Table1"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kusto.AttachedDatabaseConfiguration;
 * import com.pulumi.azurenative.kusto.AttachedDatabaseConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var attachedDatabaseConfiguration = new AttachedDatabaseConfiguration("attachedDatabaseConfiguration", AttachedDatabaseConfigurationArgs.builder()
 *             .attachedDatabaseConfigurationName("attachedDatabaseConfigurationsTest")
 *             .clusterName("kustoCluster2")
 *             .clusterResourceId("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Kusto/Clusters/kustoCluster2")
 *             .databaseName("kustodatabase")
 *             .databaseNameOverride("overridekustodatabase")
 *             .defaultPrincipalsModificationKind("Union")
 *             .location("westus")
 *             .resourceGroupName("kustorptest")
 *             .tableLevelSharingProperties(Map.ofEntries(
 *                 Map.entry("externalTablesToExclude", "ExternalTable2"),
 *                 Map.entry("externalTablesToInclude", "ExternalTable1"),
 *                 Map.entry("materializedViewsToExclude", "MaterializedViewTable2"),
 *                 Map.entry("materializedViewsToInclude", "MaterializedViewTable1"),
 *                 Map.entry("tablesToExclude", "Table2"),
 *                 Map.entry("tablesToInclude", "Table1")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:kusto:AttachedDatabaseConfiguration kustoCluster2/attachedDatabaseConfigurationsTest /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kusto/clusters/{clusterName}/attachedDatabaseConfigurations/{attachedDatabaseConfigurationName}
 * ```
 * @property attachedDatabaseConfigurationName The name of the attached database configuration.
 * @property clusterName The name of the Kusto cluster.
 * @property clusterResourceId The resource id of the cluster where the databases you would like to attach reside.
 * @property databaseName The name of the database which you would like to attach, use * if you want to follow all current and future databases.
 * @property databaseNameOverride Overrides the original database name. Relevant only when attaching to a specific database.
 * @property databaseNamePrefix Adds a prefix to the attached databases name. When following an entire cluster, that prefix would be added to all of the databases original names from leader cluster.
 * @property defaultPrincipalsModificationKind The default principals modification kind
 * @property location Resource location.
 * @property resourceGroupName The name of the resource group containing the Kusto cluster.
 * @property tableLevelSharingProperties Table level sharing specifications
 */
public data class AttachedDatabaseConfigurationArgs(
    public val attachedDatabaseConfigurationName: Output<String>? = null,
    public val clusterName: Output<String>? = null,
    public val clusterResourceId: Output<String>? = null,
    public val databaseName: Output<String>? = null,
    public val databaseNameOverride: Output<String>? = null,
    public val databaseNamePrefix: Output<String>? = null,
    public val defaultPrincipalsModificationKind:
    Output<Either<String, DefaultPrincipalsModificationKind>>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tableLevelSharingProperties: Output<TableLevelSharingPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.kusto.AttachedDatabaseConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.kusto.AttachedDatabaseConfigurationArgs =
        com.pulumi.azurenative.kusto.AttachedDatabaseConfigurationArgs.builder()
            .attachedDatabaseConfigurationName(
                attachedDatabaseConfigurationName?.applyValue({ args0 ->
                    args0
                }),
            )
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .clusterResourceId(clusterResourceId?.applyValue({ args0 -> args0 }))
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .databaseNameOverride(databaseNameOverride?.applyValue({ args0 -> args0 }))
            .databaseNamePrefix(databaseNamePrefix?.applyValue({ args0 -> args0 }))
            .defaultPrincipalsModificationKind(
                defaultPrincipalsModificationKind?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tableLevelSharingProperties(
                tableLevelSharingProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [AttachedDatabaseConfigurationArgs].
 */
@PulumiTagMarker
public class AttachedDatabaseConfigurationArgsBuilder internal constructor() {
    private var attachedDatabaseConfigurationName: Output<String>? = null

    private var clusterName: Output<String>? = null

    private var clusterResourceId: Output<String>? = null

    private var databaseName: Output<String>? = null

    private var databaseNameOverride: Output<String>? = null

    private var databaseNamePrefix: Output<String>? = null

    private var defaultPrincipalsModificationKind:
        Output<Either<String, DefaultPrincipalsModificationKind>>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tableLevelSharingProperties: Output<TableLevelSharingPropertiesArgs>? = null

    /**
     * @param value The name of the attached database configuration.
     */
    @JvmName("kgukdgyiorpfrirj")
    public suspend fun attachedDatabaseConfigurationName(`value`: Output<String>) {
        this.attachedDatabaseConfigurationName = value
    }

    /**
     * @param value The name of the Kusto cluster.
     */
    @JvmName("tfkhgcghpgjorpeh")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value The resource id of the cluster where the databases you would like to attach reside.
     */
    @JvmName("hbbyhmxoesvkamix")
    public suspend fun clusterResourceId(`value`: Output<String>) {
        this.clusterResourceId = value
    }

    /**
     * @param value The name of the database which you would like to attach, use * if you want to follow all current and future databases.
     */
    @JvmName("ooqdxfayovoywlnd")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value Overrides the original database name. Relevant only when attaching to a specific database.
     */
    @JvmName("hcijxpwlnomilkuh")
    public suspend fun databaseNameOverride(`value`: Output<String>) {
        this.databaseNameOverride = value
    }

    /**
     * @param value Adds a prefix to the attached databases name. When following an entire cluster, that prefix would be added to all of the databases original names from leader cluster.
     */
    @JvmName("cglyncmopbfsgoih")
    public suspend fun databaseNamePrefix(`value`: Output<String>) {
        this.databaseNamePrefix = value
    }

    /**
     * @param value The default principals modification kind
     */
    @JvmName("hwmmbrlmxkjfauoh")
    public suspend
    fun defaultPrincipalsModificationKind(`value`: Output<Either<String, DefaultPrincipalsModificationKind>>) {
        this.defaultPrincipalsModificationKind = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("rbwscsafofbqjsrd")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group containing the Kusto cluster.
     */
    @JvmName("hylxytguxsdvwjly")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Table level sharing specifications
     */
    @JvmName("plkylswxelevyrbq")
    public suspend fun tableLevelSharingProperties(`value`: Output<TableLevelSharingPropertiesArgs>) {
        this.tableLevelSharingProperties = value
    }

    /**
     * @param value The name of the attached database configuration.
     */
    @JvmName("xkjmwyrtvuxnqlqy")
    public suspend fun attachedDatabaseConfigurationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attachedDatabaseConfigurationName = mapped
    }

    /**
     * @param value The name of the Kusto cluster.
     */
    @JvmName("oyticfgvkasxkxjf")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value The resource id of the cluster where the databases you would like to attach reside.
     */
    @JvmName("cylnbegsxlcbmjei")
    public suspend fun clusterResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterResourceId = mapped
    }

    /**
     * @param value The name of the database which you would like to attach, use * if you want to follow all current and future databases.
     */
    @JvmName("pynnloujulvfysbl")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value Overrides the original database name. Relevant only when attaching to a specific database.
     */
    @JvmName("crrvvypiqstphnnf")
    public suspend fun databaseNameOverride(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseNameOverride = mapped
    }

    /**
     * @param value Adds a prefix to the attached databases name. When following an entire cluster, that prefix would be added to all of the databases original names from leader cluster.
     */
    @JvmName("mquopouxcvdjtgod")
    public suspend fun databaseNamePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseNamePrefix = mapped
    }

    /**
     * @param value The default principals modification kind
     */
    @JvmName("kjqpentibdketdiv")
    public suspend
    fun defaultPrincipalsModificationKind(`value`: Either<String, DefaultPrincipalsModificationKind>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultPrincipalsModificationKind = mapped
    }

    /**
     * @param value The default principals modification kind
     */
    @JvmName("tofkryptashldwpc")
    public fun defaultPrincipalsModificationKind(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DefaultPrincipalsModificationKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultPrincipalsModificationKind = mapped
    }

    /**
     * @param value The default principals modification kind
     */
    @JvmName("btbdmyvyqrutdabo")
    public fun defaultPrincipalsModificationKind(`value`: DefaultPrincipalsModificationKind) {
        val toBeMapped = Either.ofRight<String, DefaultPrincipalsModificationKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultPrincipalsModificationKind = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("frkxhruihfqysjum")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group containing the Kusto cluster.
     */
    @JvmName("aihjgvjlbhpkvxvu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Table level sharing specifications
     */
    @JvmName("xmpcapwtrjjpkdut")
    public suspend fun tableLevelSharingProperties(`value`: TableLevelSharingPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableLevelSharingProperties = mapped
    }

    /**
     * @param argument Table level sharing specifications
     */
    @JvmName("ybutcvjpdtowvumc")
    public suspend
    fun tableLevelSharingProperties(argument: suspend TableLevelSharingPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = TableLevelSharingPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tableLevelSharingProperties = mapped
    }

    internal fun build(): AttachedDatabaseConfigurationArgs = AttachedDatabaseConfigurationArgs(
        attachedDatabaseConfigurationName = attachedDatabaseConfigurationName,
        clusterName = clusterName,
        clusterResourceId = clusterResourceId,
        databaseName = databaseName,
        databaseNameOverride = databaseNameOverride,
        databaseNamePrefix = databaseNamePrefix,
        defaultPrincipalsModificationKind = defaultPrincipalsModificationKind,
        location = location,
        resourceGroupName = resourceGroupName,
        tableLevelSharingProperties = tableLevelSharingProperties,
    )
}
