@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin

import com.pulumi.azurenative.kusto.kotlin.outputs.AcceptedAudiencesResponse
import com.pulumi.azurenative.kusto.kotlin.outputs.AzureSkuResponse
import com.pulumi.azurenative.kusto.kotlin.outputs.IdentityResponse
import com.pulumi.azurenative.kusto.kotlin.outputs.KeyVaultPropertiesResponse
import com.pulumi.azurenative.kusto.kotlin.outputs.LanguageExtensionsListResponse
import com.pulumi.azurenative.kusto.kotlin.outputs.OptimizedAutoscaleResponse
import com.pulumi.azurenative.kusto.kotlin.outputs.PrivateEndpointConnectionResponse
import com.pulumi.azurenative.kusto.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.kusto.kotlin.outputs.TrustedExternalTenantResponse
import com.pulumi.azurenative.kusto.kotlin.outputs.VirtualNetworkConfigurationResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.kusto.kotlin.outputs.AcceptedAudiencesResponse.Companion.toKotlin as acceptedAudiencesResponseToKotlin
import com.pulumi.azurenative.kusto.kotlin.outputs.AzureSkuResponse.Companion.toKotlin as azureSkuResponseToKotlin
import com.pulumi.azurenative.kusto.kotlin.outputs.IdentityResponse.Companion.toKotlin as identityResponseToKotlin
import com.pulumi.azurenative.kusto.kotlin.outputs.KeyVaultPropertiesResponse.Companion.toKotlin as keyVaultPropertiesResponseToKotlin
import com.pulumi.azurenative.kusto.kotlin.outputs.LanguageExtensionsListResponse.Companion.toKotlin as languageExtensionsListResponseToKotlin
import com.pulumi.azurenative.kusto.kotlin.outputs.OptimizedAutoscaleResponse.Companion.toKotlin as optimizedAutoscaleResponseToKotlin
import com.pulumi.azurenative.kusto.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin as privateEndpointConnectionResponseToKotlin
import com.pulumi.azurenative.kusto.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.kusto.kotlin.outputs.TrustedExternalTenantResponse.Companion.toKotlin as trustedExternalTenantResponseToKotlin
import com.pulumi.azurenative.kusto.kotlin.outputs.VirtualNetworkConfigurationResponse.Companion.toKotlin as virtualNetworkConfigurationResponseToKotlin

/**
 * Builder for [Cluster].
 */
@PulumiTagMarker
public class ClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClusterArgs = ClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClusterArgsBuilder.() -> Unit) {
        val builder = ClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Cluster {
        val builtJavaResource = com.pulumi.azurenative.kusto.Cluster(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Cluster(builtJavaResource)
    }
}

/**
 * Class representing a Kusto cluster.
 * Azure REST API version: 2022-12-29. Prior API version in Azure Native 1.x: 2021-01-01.
 * Other available API versions: 2022-07-07, 2023-05-02, 2023-08-15.
 * ## Example Usage
 * ### KustoClustersCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.Kusto.Cluster("cluster", new()
 *     {
 *         AllowedIpRangeList = new[]
 *         {
 *             "0.0.0.0/0",
 *         },
 *         ClusterName = "kustoCluster",
 *         EnableAutoStop = true,
 *         EnableDoubleEncryption = false,
 *         EnablePurge = true,
 *         EnableStreamingIngest = true,
 *         Identity = new AzureNative.Kusto.Inputs.IdentityArgs
 *         {
 *             Type = "SystemAssigned",
 *         },
 *         LanguageExtensions = new AzureNative.Kusto.Inputs.LanguageExtensionsListArgs
 *         {
 *             Value = new[]
 *             {
 *                 new AzureNative.Kusto.Inputs.LanguageExtensionArgs
 *                 {
 *                     LanguageExtensionImageName = "Python3_10_8",
 *                     LanguageExtensionName = "PYTHON",
 *                 },
 *                 new AzureNative.Kusto.Inputs.LanguageExtensionArgs
 *                 {
 *                     LanguageExtensionImageName = "R",
 *                     LanguageExtensionName = "R",
 *                 },
 *             },
 *         },
 *         Location = "westus",
 *         PublicIPType = "DualStack",
 *         PublicNetworkAccess = "Enabled",
 *         ResourceGroupName = "kustorptest",
 *         Sku = new AzureNative.Kusto.Inputs.AzureSkuArgs
 *         {
 *             Capacity = 2,
 *             Name = "Standard_L16as_v3",
 *             Tier = "Standard",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kusto/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kusto.NewCluster(ctx, "cluster", &kusto.ClusterArgs{
 * 			AllowedIpRangeList: pulumi.StringArray{
 * 				pulumi.String("0.0.0.0/0"),
 * 			},
 * 			ClusterName:            pulumi.String("kustoCluster"),
 * 			EnableAutoStop:         pulumi.Bool(true),
 * 			EnableDoubleEncryption: pulumi.Bool(false),
 * 			EnablePurge:            pulumi.Bool(true),
 * 			EnableStreamingIngest:  pulumi.Bool(true),
 * 			Identity: &kusto.IdentityArgs{
 * 				Type: pulumi.String("SystemAssigned"),
 * 			},
 * 			LanguageExtensions: kusto.LanguageExtensionsListResponse{
 * 				Value: kusto.LanguageExtensionArray{
 * 					&kusto.LanguageExtensionArgs{
 * 						LanguageExtensionImageName: pulumi.String("Python3_10_8"),
 * 						LanguageExtensionName:      pulumi.String("PYTHON"),
 * 					},
 * 					&kusto.LanguageExtensionArgs{
 * 						LanguageExtensionImageName: pulumi.String("R"),
 * 						LanguageExtensionName:      pulumi.String("R"),
 * 					},
 * 				},
 * 			},
 * 			Location:            pulumi.String("westus"),
 * 			PublicIPType:        pulumi.String("DualStack"),
 * 			PublicNetworkAccess: pulumi.String("Enabled"),
 * 			ResourceGroupName:   pulumi.String("kustorptest"),
 * 			Sku: &kusto.AzureSkuArgs{
 * 				Capacity: pulumi.Int(2),
 * 				Name:     pulumi.String("Standard_L16as_v3"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kusto.Cluster;
 * import com.pulumi.azurenative.kusto.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .allowedIpRangeList("0.0.0.0/0")
 *             .clusterName("kustoCluster")
 *             .enableAutoStop(true)
 *             .enableDoubleEncryption(false)
 *             .enablePurge(true)
 *             .enableStreamingIngest(true)
 *             .identity(Map.of("type", "SystemAssigned"))
 *             .languageExtensions(Map.of("value",
 *                 Map.ofEntries(
 *                     Map.entry("languageExtensionImageName", "Python3_10_8"),
 *                     Map.entry("languageExtensionName", "PYTHON")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("languageExtensionImageName", "R"),
 *                     Map.entry("languageExtensionName", "R")
 *                 )))
 *             .location("westus")
 *             .publicIPType("DualStack")
 *             .publicNetworkAccess("Enabled")
 *             .resourceGroupName("kustorptest")
 *             .sku(Map.ofEntries(
 *                 Map.entry("capacity", 2),
 *                 Map.entry("name", "Standard_L16as_v3"),
 *                 Map.entry("tier", "Standard")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:kusto:Cluster kustoCluster /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kusto/clusters/{clusterName}
 * ```
 */
public class Cluster internal constructor(
    override val javaResource: com.pulumi.azurenative.kusto.Cluster,
) : KotlinCustomResource(javaResource, ClusterMapper) {
    /**
     * The cluster's accepted audiences.
     */
    public val acceptedAudiences: Output<List<AcceptedAudiencesResponse>>?
        get() = javaResource.acceptedAudiences().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        acceptedAudiencesResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * List of allowed FQDNs(Fully Qualified Domain Name) for egress from Cluster.
     */
    public val allowedFqdnList: Output<List<String>>?
        get() = javaResource.allowedFqdnList().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The list of ips in the format of CIDR allowed to connect to the cluster.
     */
    public val allowedIpRangeList: Output<List<String>>?
        get() = javaResource.allowedIpRangeList().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The cluster data ingestion URI.
     */
    public val dataIngestionUri: Output<String>
        get() = javaResource.dataIngestionUri().applyValue({ args0 -> args0 })

    /**
     * A boolean value that indicates if the cluster could be automatically stopped (due to lack of data or no activity for many days).
     */
    public val enableAutoStop: Output<Boolean>?
        get() = javaResource.enableAutoStop().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A boolean value that indicates if the cluster's disks are encrypted.
     */
    public val enableDiskEncryption: Output<Boolean>?
        get() = javaResource.enableDiskEncryption().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A boolean value that indicates if double encryption is enabled.
     */
    public val enableDoubleEncryption: Output<Boolean>?
        get() = javaResource.enableDoubleEncryption().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A boolean value that indicates if the purge operations are enabled.
     */
    public val enablePurge: Output<Boolean>?
        get() = javaResource.enablePurge().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A boolean value that indicates if the streaming ingest is enabled.
     */
    public val enableStreamingIngest: Output<Boolean>?
        get() = javaResource.enableStreamingIngest().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The engine type
     */
    public val engineType: Output<String>?
        get() = javaResource.engineType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The identity of the cluster, if configured.
     */
    public val identity: Output<IdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    identityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * KeyVault properties for the cluster encryption.
     */
    public val keyVaultProperties: Output<KeyVaultPropertiesResponse>?
        get() = javaResource.keyVaultProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> keyVaultPropertiesResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * List of the cluster's language extensions.
     */
    public val languageExtensions: Output<LanguageExtensionsListResponse>?
        get() = javaResource.languageExtensions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> languageExtensionsListResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Optimized auto scale definition.
     */
    public val optimizedAutoscale: Output<OptimizedAutoscaleResponse>?
        get() = javaResource.optimizedAutoscale().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> optimizedAutoscaleResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A list of private endpoint connections.
     */
    public val privateEndpointConnections: Output<List<PrivateEndpointConnectionResponse>>
        get() = javaResource.privateEndpointConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateEndpointConnectionResponseToKotlin(args0) })
            })
        })

    /**
     * The provisioned state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Indicates what public IP type to create - IPv4 (default), or DualStack (both IPv4 and IPv6)
     */
    public val publicIPType: Output<String>?
        get() = javaResource.publicIPType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Public network access to the cluster is enabled by default. When disabled, only private endpoint connection to the cluster is allowed
     */
    public val publicNetworkAccess: Output<String>?
        get() = javaResource.publicNetworkAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether or not to restrict outbound network access.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'
     */
    public val restrictOutboundNetworkAccess: Output<String>?
        get() = javaResource.restrictOutboundNetworkAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The SKU of the cluster.
     */
    public val sku: Output<AzureSkuResponse>
        get() = javaResource.sku().applyValue({ args0 ->
            args0.let({ args0 ->
                azureSkuResponseToKotlin(args0)
            })
        })

    /**
     * The state of the resource.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * The reason for the cluster's current state.
     */
    public val stateReason: Output<String>
        get() = javaResource.stateReason().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The cluster's external tenants.
     */
    public val trustedExternalTenants: Output<List<TrustedExternalTenantResponse>>?
        get() = javaResource.trustedExternalTenants().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        trustedExternalTenantResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The cluster URI.
     */
    public val uri: Output<String>
        get() = javaResource.uri().applyValue({ args0 -> args0 })

    /**
     * Virtual network definition.
     */
    public val virtualNetworkConfiguration: Output<VirtualNetworkConfigurationResponse>?
        get() = javaResource.virtualNetworkConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> virtualNetworkConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The availability zones of the cluster.
     */
    public val zones: Output<List<String>>?
        get() = javaResource.zones().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object ClusterMapper : ResourceMapper<Cluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.kusto.Cluster::class == javaResource::class

    override fun map(javaResource: Resource): Cluster = Cluster(
        javaResource as
            com.pulumi.azurenative.kusto.Cluster,
    )
}

/**
 * @see [Cluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Cluster].
 */
public suspend fun cluster(name: String, block: suspend ClusterResourceBuilder.() -> Unit):
    Cluster {
    val builder = ClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Cluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun cluster(name: String): Cluster {
    val builder = ClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
