@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ClusterPrincipalAssignment].
 */
@PulumiTagMarker
public class ClusterPrincipalAssignmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClusterPrincipalAssignmentArgs = ClusterPrincipalAssignmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClusterPrincipalAssignmentArgsBuilder.() -> Unit) {
        val builder = ClusterPrincipalAssignmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ClusterPrincipalAssignment {
        val builtJavaResource =
            com.pulumi.azurenative.kusto.ClusterPrincipalAssignment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ClusterPrincipalAssignment(builtJavaResource)
    }
}

/**
 * Class representing a cluster principal assignment.
 * Azure REST API version: 2022-12-29. Prior API version in Azure Native 1.x: 2021-01-01.
 * Other available API versions: 2023-05-02, 2023-08-15.
 * ## Example Usage
 * ### KustoClusterPrincipalAssignmentsCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var clusterPrincipalAssignment = new AzureNative.Kusto.ClusterPrincipalAssignment("clusterPrincipalAssignment", new()
 *     {
 *         ClusterName = "kustoCluster",
 *         PrincipalAssignmentName = "kustoprincipal1",
 *         PrincipalId = "87654321-1234-1234-1234-123456789123",
 *         PrincipalType = "App",
 *         ResourceGroupName = "kustorptest",
 *         Role = "AllDatabasesAdmin",
 *         TenantId = "12345678-1234-1234-1234-123456789123",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kusto/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kusto.NewClusterPrincipalAssignment(ctx, "clusterPrincipalAssignment", &kusto.ClusterPrincipalAssignmentArgs{
 * 			ClusterName:             pulumi.String("kustoCluster"),
 * 			PrincipalAssignmentName: pulumi.String("kustoprincipal1"),
 * 			PrincipalId:             pulumi.String("87654321-1234-1234-1234-123456789123"),
 * 			PrincipalType:           pulumi.String("App"),
 * 			ResourceGroupName:       pulumi.String("kustorptest"),
 * 			Role:                    pulumi.String("AllDatabasesAdmin"),
 * 			TenantId:                pulumi.String("12345678-1234-1234-1234-123456789123"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kusto.ClusterPrincipalAssignment;
 * import com.pulumi.azurenative.kusto.ClusterPrincipalAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var clusterPrincipalAssignment = new ClusterPrincipalAssignment("clusterPrincipalAssignment", ClusterPrincipalAssignmentArgs.builder()
 *             .clusterName("kustoCluster")
 *             .principalAssignmentName("kustoprincipal1")
 *             .principalId("87654321-1234-1234-1234-123456789123")
 *             .principalType("App")
 *             .resourceGroupName("kustorptest")
 *             .role("AllDatabasesAdmin")
 *             .tenantId("12345678-1234-1234-1234-123456789123")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:kusto:ClusterPrincipalAssignment kustoCluster/kustoprincipal1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kusto/clusters/{clusterName}/principalAssignments/{principalAssignmentName}
 * ```
 */
public class ClusterPrincipalAssignment internal constructor(
    override val javaResource: com.pulumi.azurenative.kusto.ClusterPrincipalAssignment,
) : KotlinCustomResource(javaResource, ClusterPrincipalAssignmentMapper) {
    /**
     * The service principal object id in AAD (Azure active directory)
     */
    public val aadObjectId: Output<String>
        get() = javaResource.aadObjectId().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The principal ID assigned to the cluster principal. It can be a user email, application ID, or security group name.
     */
    public val principalId: Output<String>
        get() = javaResource.principalId().applyValue({ args0 -> args0 })

    /**
     * The principal name
     */
    public val principalName: Output<String>
        get() = javaResource.principalName().applyValue({ args0 -> args0 })

    /**
     * Principal type.
     */
    public val principalType: Output<String>
        get() = javaResource.principalType().applyValue({ args0 -> args0 })

    /**
     * The provisioned state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Cluster principal role.
     */
    public val role: Output<String>
        get() = javaResource.role().applyValue({ args0 -> args0 })

    /**
     * The tenant id of the principal
     */
    public val tenantId: Output<String>?
        get() = javaResource.tenantId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The tenant name of the principal
     */
    public val tenantName: Output<String>
        get() = javaResource.tenantName().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ClusterPrincipalAssignmentMapper : ResourceMapper<ClusterPrincipalAssignment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.kusto.ClusterPrincipalAssignment::class == javaResource::class

    override fun map(javaResource: Resource): ClusterPrincipalAssignment =
        ClusterPrincipalAssignment(
            javaResource as
                com.pulumi.azurenative.kusto.ClusterPrincipalAssignment,
        )
}

/**
 * @see [ClusterPrincipalAssignment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ClusterPrincipalAssignment].
 */
public suspend fun clusterPrincipalAssignment(
    name: String,
    block: suspend ClusterPrincipalAssignmentResourceBuilder.() -> Unit,
):
    ClusterPrincipalAssignment {
    val builder = ClusterPrincipalAssignmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ClusterPrincipalAssignment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun clusterPrincipalAssignment(name: String): ClusterPrincipalAssignment {
    val builder = ClusterPrincipalAssignmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
