@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin

import com.pulumi.azurenative.kusto.EventGridDataConnectionArgs.builder
import com.pulumi.azurenative.kusto.kotlin.enums.BlobStorageEventType
import com.pulumi.azurenative.kusto.kotlin.enums.DatabaseRouting
import com.pulumi.azurenative.kusto.kotlin.enums.EventGridDataFormat
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Class representing an Event Grid data connection.
 * Azure REST API version: 2022-12-29. Prior API version in Azure Native 1.x: 2021-01-01.
 * ## Example Usage
 * ### KustoDataConnectionsCosmosDbCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var eventGridDataConnection = new AzureNative.Kusto.EventGridDataConnection("eventGridDataConnection", new()
 *     {
 *         ClusterName = "kustoCluster",
 *         DataConnectionName = "dataConnectionTest",
 *         DatabaseName = "KustoDatabase1",
 *         ResourceGroupName = "kustorptest",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kusto/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kusto.NewEventGridDataConnection(ctx, "eventGridDataConnection", &kusto.EventGridDataConnectionArgs{
 * 			ClusterName:        pulumi.String("kustoCluster"),
 * 			DataConnectionName: pulumi.String("dataConnectionTest"),
 * 			DatabaseName:       pulumi.String("KustoDatabase1"),
 * 			ResourceGroupName:  pulumi.String("kustorptest"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kusto.EventGridDataConnection;
 * import com.pulumi.azurenative.kusto.EventGridDataConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eventGridDataConnection = new EventGridDataConnection("eventGridDataConnection", EventGridDataConnectionArgs.builder()
 *             .clusterName("kustoCluster")
 *             .dataConnectionName("dataConnectionTest")
 *             .databaseName("KustoDatabase1")
 *             .resourceGroupName("kustorptest")
 *             .build());
 *     }
 * }
 * ```
 * ### KustoDataConnectionsCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var eventGridDataConnection = new AzureNative.Kusto.EventGridDataConnection("eventGridDataConnection", new()
 *     {
 *         ClusterName = "kustoCluster",
 *         DataConnectionName = "dataConnectionTest",
 *         DatabaseName = "KustoDatabase8",
 *         ResourceGroupName = "kustorptest",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kusto/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kusto.NewEventGridDataConnection(ctx, "eventGridDataConnection", &kusto.EventGridDataConnectionArgs{
 * 			ClusterName:        pulumi.String("kustoCluster"),
 * 			DataConnectionName: pulumi.String("dataConnectionTest"),
 * 			DatabaseName:       pulumi.String("KustoDatabase8"),
 * 			ResourceGroupName:  pulumi.String("kustorptest"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kusto.EventGridDataConnection;
 * import com.pulumi.azurenative.kusto.EventGridDataConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eventGridDataConnection = new EventGridDataConnection("eventGridDataConnection", EventGridDataConnectionArgs.builder()
 *             .clusterName("kustoCluster")
 *             .dataConnectionName("dataConnectionTest")
 *             .databaseName("KustoDatabase8")
 *             .resourceGroupName("kustorptest")
 *             .build());
 *     }
 * }
 * ```
 * ### KustoDataConnectionsEventGridCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var eventGridDataConnection = new AzureNative.Kusto.EventGridDataConnection("eventGridDataConnection", new()
 *     {
 *         BlobStorageEventType = "Microsoft.Storage.BlobCreated",
 *         ClusterName = "kustoCluster",
 *         ConsumerGroup = "$Default",
 *         DataConnectionName = "dataConnectionTest",
 *         DataFormat = "JSON",
 *         DatabaseName = "KustoDatabase8",
 *         DatabaseRouting = "Single",
 *         EventGridResourceId = "/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Storage/storageAccounts/teststorageaccount/providers/Microsoft.EventGrid/eventSubscriptions/eventSubscriptionTest",
 *         EventHubResourceId = "/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.EventHub/namespaces/eventhubTestns1/eventhubs/eventhubTest2",
 *         IgnoreFirstRecord = false,
 *         Kind = "EventGrid",
 *         Location = "westus",
 *         ManagedIdentityResourceId = "/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.ManagedIdentity/userAssignedIdentities/managedidentityTest1",
 *         MappingRuleName = "TestMapping",
 *         ResourceGroupName = "kustorptest",
 *         StorageAccountResourceId = "/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Storage/storageAccounts/teststorageaccount",
 *         TableName = "TestTable",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kusto/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kusto.NewEventGridDataConnection(ctx, "eventGridDataConnection", &kusto.EventGridDataConnectionArgs{
 * 			BlobStorageEventType:      pulumi.String("Microsoft.Storage.BlobCreated"),
 * 			ClusterName:               pulumi.String("kustoCluster"),
 * 			ConsumerGroup:             pulumi.String("$Default"),
 * 			DataConnectionName:        pulumi.String("dataConnectionTest"),
 * 			DataFormat:                pulumi.String("JSON"),
 * 			DatabaseName:              pulumi.String("KustoDatabase8"),
 * 			DatabaseRouting:           pulumi.String("Single"),
 * 			EventGridResourceId:       pulumi.String("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Storage/storageAccounts/teststorageaccount/providers/Microsoft.EventGrid/eventSubscriptions/eventSubscriptionTest"),
 * 			EventHubResourceId:        pulumi.String("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.EventHub/namespaces/eventhubTestns1/eventhubs/eventhubTest2"),
 * 			IgnoreFirstRecord:         pulumi.Bool(false),
 * 			Kind:                      pulumi.String("EventGrid"),
 * 			Location:                  pulumi.String("westus"),
 * 			ManagedIdentityResourceId: pulumi.String("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.ManagedIdentity/userAssignedIdentities/managedidentityTest1"),
 * 			MappingRuleName:           pulumi.String("TestMapping"),
 * 			ResourceGroupName:         pulumi.String("kustorptest"),
 * 			StorageAccountResourceId:  pulumi.String("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Storage/storageAccounts/teststorageaccount"),
 * 			TableName:                 pulumi.String("TestTable"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kusto.EventGridDataConnection;
 * import com.pulumi.azurenative.kusto.EventGridDataConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eventGridDataConnection = new EventGridDataConnection("eventGridDataConnection", EventGridDataConnectionArgs.builder()
 *             .blobStorageEventType("Microsoft.Storage.BlobCreated")
 *             .clusterName("kustoCluster")
 *             .consumerGroup("$Default")
 *             .dataConnectionName("dataConnectionTest")
 *             .dataFormat("JSON")
 *             .databaseName("KustoDatabase8")
 *             .databaseRouting("Single")
 *             .eventGridResourceId("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Storage/storageAccounts/teststorageaccount/providers/Microsoft.EventGrid/eventSubscriptions/eventSubscriptionTest")
 *             .eventHubResourceId("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.EventHub/namespaces/eventhubTestns1/eventhubs/eventhubTest2")
 *             .ignoreFirstRecord(false)
 *             .kind("EventGrid")
 *             .location("westus")
 *             .managedIdentityResourceId("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.ManagedIdentity/userAssignedIdentities/managedidentityTest1")
 *             .mappingRuleName("TestMapping")
 *             .resourceGroupName("kustorptest")
 *             .storageAccountResourceId("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Storage/storageAccounts/teststorageaccount")
 *             .tableName("TestTable")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:kusto:EventGridDataConnection kustoCluster/KustoDatabase8/dataConnectionTest /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kusto/clusters/{clusterName}/databases/{databaseName}/dataConnections/{dataConnectionName}
 * ```
 * @property blobStorageEventType The name of blob storage event type to process.
 * @property clusterName The name of the Kusto cluster.
 * @property consumerGroup The event hub consumer group.
 * @property dataConnectionName The name of the data connection.
 * @property dataFormat The data format of the message. Optionally the data format can be added to each message.
 * @property databaseName The name of the database in the Kusto cluster.
 * @property databaseRouting Indication for database routing information from the data connection, by default only database routing information is allowed
 * @property eventGridResourceId The resource ID of the event grid that is subscribed to the storage account events.
 * @property eventHubResourceId The resource ID where the event grid is configured to send events.
 * @property ignoreFirstRecord A Boolean value that, if set to true, indicates that ingestion should ignore the first record of every file
 * @property kind Kind of the endpoint for the data connection
 * Expected value is 'EventGrid'.
 * @property location Resource location.
 * @property managedIdentityResourceId The resource ID of a managed identity (system or user assigned) to be used to authenticate with event hub and storage account.
 * @property mappingRuleName The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
 * @property resourceGroupName The name of the resource group containing the Kusto cluster.
 * @property storageAccountResourceId The resource ID of the storage account where the data resides.
 * @property tableName The table where the data should be ingested. Optionally the table information can be added to each message.
 */
public data class EventGridDataConnectionArgs(
    public val blobStorageEventType: Output<Either<String, BlobStorageEventType>>? = null,
    public val clusterName: Output<String>? = null,
    public val consumerGroup: Output<String>? = null,
    public val dataConnectionName: Output<String>? = null,
    public val dataFormat: Output<Either<String, EventGridDataFormat>>? = null,
    public val databaseName: Output<String>? = null,
    public val databaseRouting: Output<Either<String, DatabaseRouting>>? = null,
    public val eventGridResourceId: Output<String>? = null,
    public val eventHubResourceId: Output<String>? = null,
    public val ignoreFirstRecord: Output<Boolean>? = null,
    public val kind: Output<String>? = null,
    public val location: Output<String>? = null,
    public val managedIdentityResourceId: Output<String>? = null,
    public val mappingRuleName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val storageAccountResourceId: Output<String>? = null,
    public val tableName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.kusto.EventGridDataConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.kusto.EventGridDataConnectionArgs =
        com.pulumi.azurenative.kusto.EventGridDataConnectionArgs.builder()
            .blobStorageEventType(
                blobStorageEventType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .consumerGroup(consumerGroup?.applyValue({ args0 -> args0 }))
            .dataConnectionName(dataConnectionName?.applyValue({ args0 -> args0 }))
            .dataFormat(
                dataFormat?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .databaseRouting(
                databaseRouting?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .eventGridResourceId(eventGridResourceId?.applyValue({ args0 -> args0 }))
            .eventHubResourceId(eventHubResourceId?.applyValue({ args0 -> args0 }))
            .ignoreFirstRecord(ignoreFirstRecord?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .managedIdentityResourceId(managedIdentityResourceId?.applyValue({ args0 -> args0 }))
            .mappingRuleName(mappingRuleName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .storageAccountResourceId(storageAccountResourceId?.applyValue({ args0 -> args0 }))
            .tableName(tableName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventGridDataConnectionArgs].
 */
@PulumiTagMarker
public class EventGridDataConnectionArgsBuilder internal constructor() {
    private var blobStorageEventType: Output<Either<String, BlobStorageEventType>>? = null

    private var clusterName: Output<String>? = null

    private var consumerGroup: Output<String>? = null

    private var dataConnectionName: Output<String>? = null

    private var dataFormat: Output<Either<String, EventGridDataFormat>>? = null

    private var databaseName: Output<String>? = null

    private var databaseRouting: Output<Either<String, DatabaseRouting>>? = null

    private var eventGridResourceId: Output<String>? = null

    private var eventHubResourceId: Output<String>? = null

    private var ignoreFirstRecord: Output<Boolean>? = null

    private var kind: Output<String>? = null

    private var location: Output<String>? = null

    private var managedIdentityResourceId: Output<String>? = null

    private var mappingRuleName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var storageAccountResourceId: Output<String>? = null

    private var tableName: Output<String>? = null

    /**
     * @param value The name of blob storage event type to process.
     */
    @JvmName("yjbbbeuaiqmdqmve")
    public suspend fun blobStorageEventType(`value`: Output<Either<String, BlobStorageEventType>>) {
        this.blobStorageEventType = value
    }

    /**
     * @param value The name of the Kusto cluster.
     */
    @JvmName("hwqgpgjdlmawvikh")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value The event hub consumer group.
     */
    @JvmName("cnrqwfeeeddyvfdu")
    public suspend fun consumerGroup(`value`: Output<String>) {
        this.consumerGroup = value
    }

    /**
     * @param value The name of the data connection.
     */
    @JvmName("dvyprjsagykpwlkp")
    public suspend fun dataConnectionName(`value`: Output<String>) {
        this.dataConnectionName = value
    }

    /**
     * @param value The data format of the message. Optionally the data format can be added to each message.
     */
    @JvmName("ckluxpuealauwdfq")
    public suspend fun dataFormat(`value`: Output<Either<String, EventGridDataFormat>>) {
        this.dataFormat = value
    }

    /**
     * @param value The name of the database in the Kusto cluster.
     */
    @JvmName("mrcftududkqjsqvp")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value Indication for database routing information from the data connection, by default only database routing information is allowed
     */
    @JvmName("cydwwpiickjourye")
    public suspend fun databaseRouting(`value`: Output<Either<String, DatabaseRouting>>) {
        this.databaseRouting = value
    }

    /**
     * @param value The resource ID of the event grid that is subscribed to the storage account events.
     */
    @JvmName("erqghutykqyelkxl")
    public suspend fun eventGridResourceId(`value`: Output<String>) {
        this.eventGridResourceId = value
    }

    /**
     * @param value The resource ID where the event grid is configured to send events.
     */
    @JvmName("ifplbvbmoyhidhib")
    public suspend fun eventHubResourceId(`value`: Output<String>) {
        this.eventHubResourceId = value
    }

    /**
     * @param value A Boolean value that, if set to true, indicates that ingestion should ignore the first record of every file
     */
    @JvmName("btmsuxylnusaqmnl")
    public suspend fun ignoreFirstRecord(`value`: Output<Boolean>) {
        this.ignoreFirstRecord = value
    }

    /**
     * @param value Kind of the endpoint for the data connection
     * Expected value is 'EventGrid'.
     */
    @JvmName("vluomosdccgiktak")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("gmctktyrxcysdyjy")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The resource ID of a managed identity (system or user assigned) to be used to authenticate with event hub and storage account.
     */
    @JvmName("alcsjkbpetbkxfuy")
    public suspend fun managedIdentityResourceId(`value`: Output<String>) {
        this.managedIdentityResourceId = value
    }

    /**
     * @param value The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
     */
    @JvmName("wpssiyrawweurxrm")
    public suspend fun mappingRuleName(`value`: Output<String>) {
        this.mappingRuleName = value
    }

    /**
     * @param value The name of the resource group containing the Kusto cluster.
     */
    @JvmName("ytydfxrcuubcbeqs")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The resource ID of the storage account where the data resides.
     */
    @JvmName("uvckxnxqyysfrhjw")
    public suspend fun storageAccountResourceId(`value`: Output<String>) {
        this.storageAccountResourceId = value
    }

    /**
     * @param value The table where the data should be ingested. Optionally the table information can be added to each message.
     */
    @JvmName("jliclbnmaxkomcwm")
    public suspend fun tableName(`value`: Output<String>) {
        this.tableName = value
    }

    /**
     * @param value The name of blob storage event type to process.
     */
    @JvmName("xuuufbrujrdrghhr")
    public suspend fun blobStorageEventType(`value`: Either<String, BlobStorageEventType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blobStorageEventType = mapped
    }

    /**
     * @param value The name of blob storage event type to process.
     */
    @JvmName("wpbclycapbjxswif")
    public fun blobStorageEventType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BlobStorageEventType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.blobStorageEventType = mapped
    }

    /**
     * @param value The name of blob storage event type to process.
     */
    @JvmName("emgemiywqwdlximt")
    public fun blobStorageEventType(`value`: BlobStorageEventType) {
        val toBeMapped = Either.ofRight<String, BlobStorageEventType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.blobStorageEventType = mapped
    }

    /**
     * @param value The name of the Kusto cluster.
     */
    @JvmName("ocnlwdrhhrbtbpnh")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value The event hub consumer group.
     */
    @JvmName("mdsjypkqhxoqkjge")
    public suspend fun consumerGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.consumerGroup = mapped
    }

    /**
     * @param value The name of the data connection.
     */
    @JvmName("xdtcivwxpcgdgboc")
    public suspend fun dataConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataConnectionName = mapped
    }

    /**
     * @param value The data format of the message. Optionally the data format can be added to each message.
     */
    @JvmName("pdpsgjaqujvqcvxv")
    public suspend fun dataFormat(`value`: Either<String, EventGridDataFormat>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataFormat = mapped
    }

    /**
     * @param value The data format of the message. Optionally the data format can be added to each message.
     */
    @JvmName("evspnymkygldqkab")
    public fun dataFormat(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EventGridDataFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataFormat = mapped
    }

    /**
     * @param value The data format of the message. Optionally the data format can be added to each message.
     */
    @JvmName("ggldiyybvudwbywv")
    public fun dataFormat(`value`: EventGridDataFormat) {
        val toBeMapped = Either.ofRight<String, EventGridDataFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataFormat = mapped
    }

    /**
     * @param value The name of the database in the Kusto cluster.
     */
    @JvmName("inarskcaybdlgrui")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value Indication for database routing information from the data connection, by default only database routing information is allowed
     */
    @JvmName("ijjwdyulhpsihwom")
    public suspend fun databaseRouting(`value`: Either<String, DatabaseRouting>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseRouting = mapped
    }

    /**
     * @param value Indication for database routing information from the data connection, by default only database routing information is allowed
     */
    @JvmName("pwvbsqgmoipbneih")
    public fun databaseRouting(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DatabaseRouting>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databaseRouting = mapped
    }

    /**
     * @param value Indication for database routing information from the data connection, by default only database routing information is allowed
     */
    @JvmName("vrvsusrvxwlhompk")
    public fun databaseRouting(`value`: DatabaseRouting) {
        val toBeMapped = Either.ofRight<String, DatabaseRouting>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databaseRouting = mapped
    }

    /**
     * @param value The resource ID of the event grid that is subscribed to the storage account events.
     */
    @JvmName("jvypdrofnmlfwmvp")
    public suspend fun eventGridResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventGridResourceId = mapped
    }

    /**
     * @param value The resource ID where the event grid is configured to send events.
     */
    @JvmName("fgleaicqdsywnqbk")
    public suspend fun eventHubResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventHubResourceId = mapped
    }

    /**
     * @param value A Boolean value that, if set to true, indicates that ingestion should ignore the first record of every file
     */
    @JvmName("brfmlobmnvruaxqu")
    public suspend fun ignoreFirstRecord(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignoreFirstRecord = mapped
    }

    /**
     * @param value Kind of the endpoint for the data connection
     * Expected value is 'EventGrid'.
     */
    @JvmName("llskpxtpudyayijs")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("kmogehjrjpntahcf")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The resource ID of a managed identity (system or user assigned) to be used to authenticate with event hub and storage account.
     */
    @JvmName("nojpwvhsfgibmdmq")
    public suspend fun managedIdentityResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedIdentityResourceId = mapped
    }

    /**
     * @param value The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
     */
    @JvmName("jjafctoowyxfhdej")
    public suspend fun mappingRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mappingRuleName = mapped
    }

    /**
     * @param value The name of the resource group containing the Kusto cluster.
     */
    @JvmName("mfjdraqugtflrcug")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The resource ID of the storage account where the data resides.
     */
    @JvmName("fjptkpwqdhmkynxg")
    public suspend fun storageAccountResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountResourceId = mapped
    }

    /**
     * @param value The table where the data should be ingested. Optionally the table information can be added to each message.
     */
    @JvmName("ffjsaslvsweovtvu")
    public suspend fun tableName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableName = mapped
    }

    internal fun build(): EventGridDataConnectionArgs = EventGridDataConnectionArgs(
        blobStorageEventType = blobStorageEventType,
        clusterName = clusterName,
        consumerGroup = consumerGroup,
        dataConnectionName = dataConnectionName,
        dataFormat = dataFormat,
        databaseName = databaseName,
        databaseRouting = databaseRouting,
        eventGridResourceId = eventGridResourceId,
        eventHubResourceId = eventHubResourceId,
        ignoreFirstRecord = ignoreFirstRecord,
        kind = kind,
        location = location,
        managedIdentityResourceId = managedIdentityResourceId,
        mappingRuleName = mappingRuleName,
        resourceGroupName = resourceGroupName,
        storageAccountResourceId = storageAccountResourceId,
        tableName = tableName,
    )
}
