@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin

import com.pulumi.azurenative.kusto.EventHubConnectionArgs.builder
import com.pulumi.azurenative.kusto.kotlin.enums.DataFormat
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Class representing an event hub connection.
 * Azure REST API version: 2018-09-07-preview. Prior API version in Azure Native 1.x: 2018-09-07-preview.
 * ## Example Usage
 * ### KustoEventHubConnectionsCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var eventHubConnection = new AzureNative.Kusto.EventHubConnection("eventHubConnection", new()
 *     {
 *         ClusterName = "KustoClusterRPTest4",
 *         ConsumerGroup = "testConsumerGroup1",
 *         DatabaseName = "KustoDatabase8",
 *         EventHubConnectionName = "kustoeventhubconnection1",
 *         EventHubResourceId = "/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.EventHub/namespaces/eventhubTestns1/eventhubs/eventhubTest1",
 *         Location = "westus",
 *         ResourceGroupName = "kustorptest",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kusto/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kusto.NewEventHubConnection(ctx, "eventHubConnection", &kusto.EventHubConnectionArgs{
 * 			ClusterName:            pulumi.String("KustoClusterRPTest4"),
 * 			ConsumerGroup:          pulumi.String("testConsumerGroup1"),
 * 			DatabaseName:           pulumi.String("KustoDatabase8"),
 * 			EventHubConnectionName: pulumi.String("kustoeventhubconnection1"),
 * 			EventHubResourceId:     pulumi.String("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.EventHub/namespaces/eventhubTestns1/eventhubs/eventhubTest1"),
 * 			Location:               pulumi.String("westus"),
 * 			ResourceGroupName:      pulumi.String("kustorptest"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kusto.EventHubConnection;
 * import com.pulumi.azurenative.kusto.EventHubConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eventHubConnection = new EventHubConnection("eventHubConnection", EventHubConnectionArgs.builder()
 *             .clusterName("KustoClusterRPTest4")
 *             .consumerGroup("testConsumerGroup1")
 *             .databaseName("KustoDatabase8")
 *             .eventHubConnectionName("kustoeventhubconnection1")
 *             .eventHubResourceId("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.EventHub/namespaces/eventhubTestns1/eventhubs/eventhubTest1")
 *             .location("westus")
 *             .resourceGroupName("kustorptest")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:kusto:EventHubConnection KustoClusterRPTest4/KustoDatabase8 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kusto/clusters/{clusterName}/databases/{databaseName}/eventhubconnections/{eventHubConnectionName}
 * ```
 * @property clusterName The name of the Kusto cluster.
 * @property consumerGroup The event hub consumer group.
 * @property dataFormat The data format of the message. Optionally the data format can be added to each message.
 * @property databaseName The name of the database in the Kusto cluster.
 * @property eventHubConnectionName The name of the event hub connection.
 * @property eventHubResourceId The resource ID of the event hub to be used to create a data connection.
 * @property location Resource location.
 * @property mappingRuleName The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
 * @property resourceGroupName The name of the resource group containing the Kusto cluster.
 * @property tableName The table where the data should be ingested. Optionally the table information can be added to each message.
 */
public data class EventHubConnectionArgs(
    public val clusterName: Output<String>? = null,
    public val consumerGroup: Output<String>? = null,
    public val dataFormat: Output<Either<String, DataFormat>>? = null,
    public val databaseName: Output<String>? = null,
    public val eventHubConnectionName: Output<String>? = null,
    public val eventHubResourceId: Output<String>? = null,
    public val location: Output<String>? = null,
    public val mappingRuleName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tableName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.kusto.EventHubConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.kusto.EventHubConnectionArgs =
        com.pulumi.azurenative.kusto.EventHubConnectionArgs.builder()
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .consumerGroup(consumerGroup?.applyValue({ args0 -> args0 }))
            .dataFormat(
                dataFormat?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .eventHubConnectionName(eventHubConnectionName?.applyValue({ args0 -> args0 }))
            .eventHubResourceId(eventHubResourceId?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .mappingRuleName(mappingRuleName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tableName(tableName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventHubConnectionArgs].
 */
@PulumiTagMarker
public class EventHubConnectionArgsBuilder internal constructor() {
    private var clusterName: Output<String>? = null

    private var consumerGroup: Output<String>? = null

    private var dataFormat: Output<Either<String, DataFormat>>? = null

    private var databaseName: Output<String>? = null

    private var eventHubConnectionName: Output<String>? = null

    private var eventHubResourceId: Output<String>? = null

    private var location: Output<String>? = null

    private var mappingRuleName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tableName: Output<String>? = null

    /**
     * @param value The name of the Kusto cluster.
     */
    @JvmName("obtbupkrplmdeyiu")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value The event hub consumer group.
     */
    @JvmName("ptpqlgnutiejfxlt")
    public suspend fun consumerGroup(`value`: Output<String>) {
        this.consumerGroup = value
    }

    /**
     * @param value The data format of the message. Optionally the data format can be added to each message.
     */
    @JvmName("jsvccchuvxlkmggo")
    public suspend fun dataFormat(`value`: Output<Either<String, DataFormat>>) {
        this.dataFormat = value
    }

    /**
     * @param value The name of the database in the Kusto cluster.
     */
    @JvmName("vhytbyaodrmhdmfu")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The name of the event hub connection.
     */
    @JvmName("igsjiomncvjinnvk")
    public suspend fun eventHubConnectionName(`value`: Output<String>) {
        this.eventHubConnectionName = value
    }

    /**
     * @param value The resource ID of the event hub to be used to create a data connection.
     */
    @JvmName("nqbkrggovvxlsdrk")
    public suspend fun eventHubResourceId(`value`: Output<String>) {
        this.eventHubResourceId = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("qrcuyyfsdylolify")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
     */
    @JvmName("qidvmgwrdsueplcr")
    public suspend fun mappingRuleName(`value`: Output<String>) {
        this.mappingRuleName = value
    }

    /**
     * @param value The name of the resource group containing the Kusto cluster.
     */
    @JvmName("fkqrgbmqekpfvrkf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The table where the data should be ingested. Optionally the table information can be added to each message.
     */
    @JvmName("ahrpwkwiruudjpvp")
    public suspend fun tableName(`value`: Output<String>) {
        this.tableName = value
    }

    /**
     * @param value The name of the Kusto cluster.
     */
    @JvmName("bvbbeqpiantvgjtv")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value The event hub consumer group.
     */
    @JvmName("cotwcmetmmbpqwls")
    public suspend fun consumerGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.consumerGroup = mapped
    }

    /**
     * @param value The data format of the message. Optionally the data format can be added to each message.
     */
    @JvmName("ksjhbebowangmopr")
    public suspend fun dataFormat(`value`: Either<String, DataFormat>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataFormat = mapped
    }

    /**
     * @param value The data format of the message. Optionally the data format can be added to each message.
     */
    @JvmName("hrevqpggifmygbow")
    public fun dataFormat(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DataFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataFormat = mapped
    }

    /**
     * @param value The data format of the message. Optionally the data format can be added to each message.
     */
    @JvmName("jwxohcseljprikrn")
    public fun dataFormat(`value`: DataFormat) {
        val toBeMapped = Either.ofRight<String, DataFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataFormat = mapped
    }

    /**
     * @param value The name of the database in the Kusto cluster.
     */
    @JvmName("bpfogsdoqinyctyr")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the event hub connection.
     */
    @JvmName("hidglalflidllbna")
    public suspend fun eventHubConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventHubConnectionName = mapped
    }

    /**
     * @param value The resource ID of the event hub to be used to create a data connection.
     */
    @JvmName("qqatulrcagojmjqy")
    public suspend fun eventHubResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventHubResourceId = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("klyirtgndkqwxmto")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
     */
    @JvmName("xaxuqkduftvatsdp")
    public suspend fun mappingRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mappingRuleName = mapped
    }

    /**
     * @param value The name of the resource group containing the Kusto cluster.
     */
    @JvmName("onifkxmduyvltbtx")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The table where the data should be ingested. Optionally the table information can be added to each message.
     */
    @JvmName("qjvcturysxjlftks")
    public suspend fun tableName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableName = mapped
    }

    internal fun build(): EventHubConnectionArgs = EventHubConnectionArgs(
        clusterName = clusterName,
        consumerGroup = consumerGroup,
        dataFormat = dataFormat,
        databaseName = databaseName,
        eventHubConnectionName = eventHubConnectionName,
        eventHubResourceId = eventHubResourceId,
        location = location,
        mappingRuleName = mappingRuleName,
        resourceGroupName = resourceGroupName,
        tableName = tableName,
    )
}
