@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The event hub messages compression type
 */
public enum class Compression(
    public val javaValue: com.pulumi.azurenative.kusto.enums.Compression,
) : ConvertibleToJava<com.pulumi.azurenative.kusto.enums.Compression> {
    None(com.pulumi.azurenative.kusto.enums.Compression.None),
    GZip(com.pulumi.azurenative.kusto.enums.Compression.GZip),
    ;

    override fun toJava(): com.pulumi.azurenative.kusto.enums.Compression = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kusto.enums.Compression): Compression =
            Compression.values().first { it.javaValue == javaType }
    }
}
