@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The data format of the message. Optionally the data format can be added to each message.
 */
public enum class DataFormat(
    public val javaValue: com.pulumi.azurenative.kusto.enums.DataFormat,
) : ConvertibleToJava<com.pulumi.azurenative.kusto.enums.DataFormat> {
    MULTIJSON(com.pulumi.azurenative.kusto.enums.DataFormat.MULTIJSON),
    JSON(com.pulumi.azurenative.kusto.enums.DataFormat.JSON),
    CSV(com.pulumi.azurenative.kusto.enums.DataFormat.CSV),
    ;

    override fun toJava(): com.pulumi.azurenative.kusto.enums.DataFormat = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kusto.enums.DataFormat): DataFormat =
            DataFormat.values().first { it.javaValue == javaType }
    }
}
