@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user-assigned identities. The type 'None' will remove all identities.
 */
public enum class IdentityType(
    public val javaValue: com.pulumi.azurenative.kusto.enums.IdentityType,
) : ConvertibleToJava<com.pulumi.azurenative.kusto.enums.IdentityType> {
    None(com.pulumi.azurenative.kusto.enums.IdentityType.None),
    SystemAssigned(com.pulumi.azurenative.kusto.enums.IdentityType.SystemAssigned),
    UserAssigned(com.pulumi.azurenative.kusto.enums.IdentityType.UserAssigned),
    SystemAssigned_UserAssigned(com.pulumi.azurenative.kusto.enums.IdentityType.SystemAssigned_UserAssigned),
    ;

    override fun toJava(): com.pulumi.azurenative.kusto.enums.IdentityType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kusto.enums.IdentityType): IdentityType =
            IdentityType.values().first { it.javaValue == javaType }
    }
}
