@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin.inputs

import com.pulumi.azurenative.kusto.inputs.LanguageExtensionArgs.builder
import com.pulumi.azurenative.kusto.kotlin.enums.LanguageExtensionImageName
import com.pulumi.azurenative.kusto.kotlin.enums.LanguageExtensionName
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The language extension object.
 * @property languageExtensionImageName The language extension image name.
 * @property languageExtensionName The language extension name.
 */
public data class LanguageExtensionArgs(
    public val languageExtensionImageName: Output<Either<String, LanguageExtensionImageName>>? = null,
    public val languageExtensionName: Output<Either<String, LanguageExtensionName>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.kusto.inputs.LanguageExtensionArgs> {
    override fun toJava(): com.pulumi.azurenative.kusto.inputs.LanguageExtensionArgs =
        com.pulumi.azurenative.kusto.inputs.LanguageExtensionArgs.builder()
            .languageExtensionImageName(
                languageExtensionImageName?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .languageExtensionName(
                languageExtensionName?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [LanguageExtensionArgs].
 */
@PulumiTagMarker
public class LanguageExtensionArgsBuilder internal constructor() {
    private var languageExtensionImageName: Output<Either<String, LanguageExtensionImageName>>? = null

    private var languageExtensionName: Output<Either<String, LanguageExtensionName>>? = null

    /**
     * @param value The language extension image name.
     */
    @JvmName("icdpmfynwlusdwxh")
    public suspend
    fun languageExtensionImageName(`value`: Output<Either<String, LanguageExtensionImageName>>) {
        this.languageExtensionImageName = value
    }

    /**
     * @param value The language extension name.
     */
    @JvmName("cysejjpecdkuagty")
    public suspend fun languageExtensionName(`value`: Output<Either<String, LanguageExtensionName>>) {
        this.languageExtensionName = value
    }

    /**
     * @param value The language extension image name.
     */
    @JvmName("jaforkuyoynsxjqf")
    public suspend
    fun languageExtensionImageName(`value`: Either<String, LanguageExtensionImageName>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.languageExtensionImageName = mapped
    }

    /**
     * @param value The language extension image name.
     */
    @JvmName("jbrwpncrfedsajpb")
    public fun languageExtensionImageName(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LanguageExtensionImageName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.languageExtensionImageName = mapped
    }

    /**
     * @param value The language extension image name.
     */
    @JvmName("ugfhvseyeqlcqhrm")
    public fun languageExtensionImageName(`value`: LanguageExtensionImageName) {
        val toBeMapped = Either.ofRight<String, LanguageExtensionImageName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.languageExtensionImageName = mapped
    }

    /**
     * @param value The language extension name.
     */
    @JvmName("kadevwrnaqmhmdlg")
    public suspend fun languageExtensionName(`value`: Either<String, LanguageExtensionName>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.languageExtensionName = mapped
    }

    /**
     * @param value The language extension name.
     */
    @JvmName("rehdrxqipncahfqp")
    public fun languageExtensionName(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LanguageExtensionName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.languageExtensionName = mapped
    }

    /**
     * @param value The language extension name.
     */
    @JvmName("nrxgcwddypuhvtir")
    public fun languageExtensionName(`value`: LanguageExtensionName) {
        val toBeMapped = Either.ofRight<String, LanguageExtensionName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.languageExtensionName = mapped
    }

    internal fun build(): LanguageExtensionArgs = LanguageExtensionArgs(
        languageExtensionImageName = languageExtensionImageName,
        languageExtensionName = languageExtensionName,
    )
}
