@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin.inputs

import com.pulumi.azurenative.kusto.inputs.TableLevelSharingPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Tables that will be included and excluded in the follower database
 * @property externalTablesToExclude List of external tables to exclude from the follower database
 * @property externalTablesToInclude List of external tables to include in the follower database
 * @property functionsToExclude List of functions to exclude from the follower database
 * @property functionsToInclude List of functions to include in the follower database
 * @property materializedViewsToExclude List of materialized views to exclude from the follower database
 * @property materializedViewsToInclude List of materialized views to include in the follower database
 * @property tablesToExclude List of tables to exclude from the follower database
 * @property tablesToInclude List of tables to include in the follower database
 */
public data class TableLevelSharingPropertiesArgs(
    public val externalTablesToExclude: Output<List<String>>? = null,
    public val externalTablesToInclude: Output<List<String>>? = null,
    public val functionsToExclude: Output<List<String>>? = null,
    public val functionsToInclude: Output<List<String>>? = null,
    public val materializedViewsToExclude: Output<List<String>>? = null,
    public val materializedViewsToInclude: Output<List<String>>? = null,
    public val tablesToExclude: Output<List<String>>? = null,
    public val tablesToInclude: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.kusto.inputs.TableLevelSharingPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.kusto.inputs.TableLevelSharingPropertiesArgs =
        com.pulumi.azurenative.kusto.inputs.TableLevelSharingPropertiesArgs.builder()
            .externalTablesToExclude(
                externalTablesToExclude?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .externalTablesToInclude(
                externalTablesToInclude?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .functionsToExclude(functionsToExclude?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .functionsToInclude(functionsToInclude?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .materializedViewsToExclude(
                materializedViewsToExclude?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .materializedViewsToInclude(
                materializedViewsToInclude?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .tablesToExclude(tablesToExclude?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tablesToInclude(tablesToInclude?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [TableLevelSharingPropertiesArgs].
 */
@PulumiTagMarker
public class TableLevelSharingPropertiesArgsBuilder internal constructor() {
    private var externalTablesToExclude: Output<List<String>>? = null

    private var externalTablesToInclude: Output<List<String>>? = null

    private var functionsToExclude: Output<List<String>>? = null

    private var functionsToInclude: Output<List<String>>? = null

    private var materializedViewsToExclude: Output<List<String>>? = null

    private var materializedViewsToInclude: Output<List<String>>? = null

    private var tablesToExclude: Output<List<String>>? = null

    private var tablesToInclude: Output<List<String>>? = null

    /**
     * @param value List of external tables to exclude from the follower database
     */
    @JvmName("qbviydvfpgtctnbh")
    public suspend fun externalTablesToExclude(`value`: Output<List<String>>) {
        this.externalTablesToExclude = value
    }

    @JvmName("aqhegywvltvebqxt")
    public suspend fun externalTablesToExclude(vararg values: Output<String>) {
        this.externalTablesToExclude = Output.all(values.asList())
    }

    /**
     * @param values List of external tables to exclude from the follower database
     */
    @JvmName("vytnjulcghobhjml")
    public suspend fun externalTablesToExclude(values: List<Output<String>>) {
        this.externalTablesToExclude = Output.all(values)
    }

    /**
     * @param value List of external tables to include in the follower database
     */
    @JvmName("vddbvcabjxdlangb")
    public suspend fun externalTablesToInclude(`value`: Output<List<String>>) {
        this.externalTablesToInclude = value
    }

    @JvmName("operwbweydvbitrm")
    public suspend fun externalTablesToInclude(vararg values: Output<String>) {
        this.externalTablesToInclude = Output.all(values.asList())
    }

    /**
     * @param values List of external tables to include in the follower database
     */
    @JvmName("prjopujhmhqhgwic")
    public suspend fun externalTablesToInclude(values: List<Output<String>>) {
        this.externalTablesToInclude = Output.all(values)
    }

    /**
     * @param value List of functions to exclude from the follower database
     */
    @JvmName("muikvncwhqxbcynm")
    public suspend fun functionsToExclude(`value`: Output<List<String>>) {
        this.functionsToExclude = value
    }

    @JvmName("ereemksefybirksl")
    public suspend fun functionsToExclude(vararg values: Output<String>) {
        this.functionsToExclude = Output.all(values.asList())
    }

    /**
     * @param values List of functions to exclude from the follower database
     */
    @JvmName("niyfvmojygkidfey")
    public suspend fun functionsToExclude(values: List<Output<String>>) {
        this.functionsToExclude = Output.all(values)
    }

    /**
     * @param value List of functions to include in the follower database
     */
    @JvmName("ynnnihypjxoeqreb")
    public suspend fun functionsToInclude(`value`: Output<List<String>>) {
        this.functionsToInclude = value
    }

    @JvmName("byywykeriumuglxn")
    public suspend fun functionsToInclude(vararg values: Output<String>) {
        this.functionsToInclude = Output.all(values.asList())
    }

    /**
     * @param values List of functions to include in the follower database
     */
    @JvmName("dhrykabfutehrphi")
    public suspend fun functionsToInclude(values: List<Output<String>>) {
        this.functionsToInclude = Output.all(values)
    }

    /**
     * @param value List of materialized views to exclude from the follower database
     */
    @JvmName("obuuqygcobydfper")
    public suspend fun materializedViewsToExclude(`value`: Output<List<String>>) {
        this.materializedViewsToExclude = value
    }

    @JvmName("spacsdjddxhmoanu")
    public suspend fun materializedViewsToExclude(vararg values: Output<String>) {
        this.materializedViewsToExclude = Output.all(values.asList())
    }

    /**
     * @param values List of materialized views to exclude from the follower database
     */
    @JvmName("weslyffkpaynbfuo")
    public suspend fun materializedViewsToExclude(values: List<Output<String>>) {
        this.materializedViewsToExclude = Output.all(values)
    }

    /**
     * @param value List of materialized views to include in the follower database
     */
    @JvmName("bbmlxavofhdpnfyu")
    public suspend fun materializedViewsToInclude(`value`: Output<List<String>>) {
        this.materializedViewsToInclude = value
    }

    @JvmName("jscsmalnqcjiayhb")
    public suspend fun materializedViewsToInclude(vararg values: Output<String>) {
        this.materializedViewsToInclude = Output.all(values.asList())
    }

    /**
     * @param values List of materialized views to include in the follower database
     */
    @JvmName("kbdjkoorugsubejb")
    public suspend fun materializedViewsToInclude(values: List<Output<String>>) {
        this.materializedViewsToInclude = Output.all(values)
    }

    /**
     * @param value List of tables to exclude from the follower database
     */
    @JvmName("ewexjrhowxwvjgor")
    public suspend fun tablesToExclude(`value`: Output<List<String>>) {
        this.tablesToExclude = value
    }

    @JvmName("najatmjpqhgsqalb")
    public suspend fun tablesToExclude(vararg values: Output<String>) {
        this.tablesToExclude = Output.all(values.asList())
    }

    /**
     * @param values List of tables to exclude from the follower database
     */
    @JvmName("yoscpjawxixccmtu")
    public suspend fun tablesToExclude(values: List<Output<String>>) {
        this.tablesToExclude = Output.all(values)
    }

    /**
     * @param value List of tables to include in the follower database
     */
    @JvmName("ahjbcskxvawuytta")
    public suspend fun tablesToInclude(`value`: Output<List<String>>) {
        this.tablesToInclude = value
    }

    @JvmName("tipassiqfoekxwli")
    public suspend fun tablesToInclude(vararg values: Output<String>) {
        this.tablesToInclude = Output.all(values.asList())
    }

    /**
     * @param values List of tables to include in the follower database
     */
    @JvmName("ilhpwaymspcmcmye")
    public suspend fun tablesToInclude(values: List<Output<String>>) {
        this.tablesToInclude = Output.all(values)
    }

    /**
     * @param value List of external tables to exclude from the follower database
     */
    @JvmName("wqbjgrmfxdvokkfy")
    public suspend fun externalTablesToExclude(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalTablesToExclude = mapped
    }

    /**
     * @param values List of external tables to exclude from the follower database
     */
    @JvmName("wnicbvvmrrvfmtxu")
    public suspend fun externalTablesToExclude(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.externalTablesToExclude = mapped
    }

    /**
     * @param value List of external tables to include in the follower database
     */
    @JvmName("sfqluiblxxxhpnbq")
    public suspend fun externalTablesToInclude(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalTablesToInclude = mapped
    }

    /**
     * @param values List of external tables to include in the follower database
     */
    @JvmName("lowpeyjrrisnueyf")
    public suspend fun externalTablesToInclude(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.externalTablesToInclude = mapped
    }

    /**
     * @param value List of functions to exclude from the follower database
     */
    @JvmName("exxxdkgaxaixvsus")
    public suspend fun functionsToExclude(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionsToExclude = mapped
    }

    /**
     * @param values List of functions to exclude from the follower database
     */
    @JvmName("hvugikohrwtaburj")
    public suspend fun functionsToExclude(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.functionsToExclude = mapped
    }

    /**
     * @param value List of functions to include in the follower database
     */
    @JvmName("sysrtidhdfrofuyl")
    public suspend fun functionsToInclude(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionsToInclude = mapped
    }

    /**
     * @param values List of functions to include in the follower database
     */
    @JvmName("nctaqhtmduhooxin")
    public suspend fun functionsToInclude(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.functionsToInclude = mapped
    }

    /**
     * @param value List of materialized views to exclude from the follower database
     */
    @JvmName("weynalodoylrwcdl")
    public suspend fun materializedViewsToExclude(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.materializedViewsToExclude = mapped
    }

    /**
     * @param values List of materialized views to exclude from the follower database
     */
    @JvmName("yappcpoaxloglapu")
    public suspend fun materializedViewsToExclude(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.materializedViewsToExclude = mapped
    }

    /**
     * @param value List of materialized views to include in the follower database
     */
    @JvmName("xirbygynckjlyokv")
    public suspend fun materializedViewsToInclude(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.materializedViewsToInclude = mapped
    }

    /**
     * @param values List of materialized views to include in the follower database
     */
    @JvmName("rgwsalaxauohqaah")
    public suspend fun materializedViewsToInclude(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.materializedViewsToInclude = mapped
    }

    /**
     * @param value List of tables to exclude from the follower database
     */
    @JvmName("pmqeixowoyfdoskx")
    public suspend fun tablesToExclude(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tablesToExclude = mapped
    }

    /**
     * @param values List of tables to exclude from the follower database
     */
    @JvmName("xckfhdavbvrviffl")
    public suspend fun tablesToExclude(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tablesToExclude = mapped
    }

    /**
     * @param value List of tables to include in the follower database
     */
    @JvmName("ovpttwknspbdqdgd")
    public suspend fun tablesToInclude(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tablesToInclude = mapped
    }

    /**
     * @param values List of tables to include in the follower database
     */
    @JvmName("psqdiubtpsfhwrje")
    public suspend fun tablesToInclude(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tablesToInclude = mapped
    }

    internal fun build(): TableLevelSharingPropertiesArgs = TableLevelSharingPropertiesArgs(
        externalTablesToExclude = externalTablesToExclude,
        externalTablesToInclude = externalTablesToInclude,
        functionsToExclude = functionsToExclude,
        functionsToInclude = functionsToInclude,
        materializedViewsToExclude = materializedViewsToExclude,
        materializedViewsToInclude = materializedViewsToInclude,
        tablesToExclude = tablesToExclude,
        tablesToInclude = tablesToInclude,
    )
}
