@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A class representing database principal entity.
 * @property appId Application id - relevant only for application principal type.
 * @property email Database principal email if exists.
 * @property fqn Database principal fully qualified name.
 * @property name Database principal name.
 * @property role Database principal role.
 * @property tenantName The tenant name of the principal
 * @property type Database principal type.
 */
public data class DatabasePrincipalResponse(
    public val appId: String? = null,
    public val email: String? = null,
    public val fqn: String? = null,
    public val name: String,
    public val role: String,
    public val tenantName: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kusto.outputs.DatabasePrincipalResponse):
            DatabasePrincipalResponse = DatabasePrincipalResponse(
            appId = javaType.appId().map({ args0 -> args0 }).orElse(null),
            email = javaType.email().map({ args0 -> args0 }).orElse(null),
            fqn = javaType.fqn().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            role = javaType.role(),
            tenantName = javaType.tenantName(),
            type = javaType.type(),
        )
    }
}
