@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A private endpoint connection
 * @property groupId Group id of the private endpoint.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property privateEndpoint Private endpoint which the connection belongs to.
 * @property privateLinkServiceConnectionState Connection State of the Private Endpoint Connection.
 * @property provisioningState Provisioning state of the private endpoint.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class PrivateEndpointConnectionResponse(
    public val groupId: String,
    public val id: String,
    public val name: String,
    public val privateEndpoint: PrivateEndpointPropertyResponse,
    public val privateLinkServiceConnectionState: PrivateLinkServiceConnectionStatePropertyResponse,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.kusto.outputs.PrivateEndpointConnectionResponse):
            PrivateEndpointConnectionResponse = PrivateEndpointConnectionResponse(
            groupId = javaType.groupId(),
            id = javaType.id(),
            name = javaType.name(),
            privateEndpoint = javaType.privateEndpoint().let({ args0 ->
                com.pulumi.azurenative.kusto.kotlin.outputs.PrivateEndpointPropertyResponse.Companion.toKotlin(args0)
            }),
            privateLinkServiceConnectionState = javaType.privateLinkServiceConnectionState().let({ args0 ->
                com.pulumi.azurenative.kusto.kotlin.outputs.PrivateLinkServiceConnectionStatePropertyResponse.Companion.toKotlin(args0)
            }),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.kusto.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
