@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin

import com.pulumi.azurenative.labservices.kotlin.outputs.LatestOperationResultResponse
import com.pulumi.azurenative.labservices.kotlin.outputs.ResourceSettingsResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.labservices.kotlin.outputs.LatestOperationResultResponse.Companion.toKotlin as latestOperationResultResponseToKotlin
import com.pulumi.azurenative.labservices.kotlin.outputs.ResourceSettingsResponse.Companion.toKotlin as resourceSettingsResponseToKotlin

/**
 * Builder for [EnvironmentSetting].
 */
@PulumiTagMarker
public class EnvironmentSettingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EnvironmentSettingArgs = EnvironmentSettingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EnvironmentSettingArgsBuilder.() -> Unit) {
        val builder = EnvironmentSettingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): EnvironmentSetting {
        val builtJavaResource =
            com.pulumi.azurenative.labservices.EnvironmentSetting(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return EnvironmentSetting(builtJavaResource)
    }
}

/**
 * Represents settings of an environment, from which environment instances would be created
 * Azure REST API version: 2018-10-15. Prior API version in Azure Native 1.x: 2018-10-15.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:labservices:EnvironmentSetting myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LabServices/labaccounts/{labAccountName}/labs/{labName}/environmentsettings/{environmentSettingName}
 * ```
 */
public class EnvironmentSetting internal constructor(
    override val javaResource: com.pulumi.azurenative.labservices.EnvironmentSetting,
) : KotlinCustomResource(javaResource, EnvironmentSettingMapper) {
    /**
     * Describes the user's progress in configuring their environment setting
     */
    public val configurationState: Output<String>?
        get() = javaResource.configurationState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Describes the environment and its resource settings
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Time when the template VM was last changed.
     */
    public val lastChanged: Output<String>
        get() = javaResource.lastChanged().applyValue({ args0 -> args0 })

    /**
     * Time when the template VM was last sent for publishing.
     */
    public val lastPublished: Output<String>
        get() = javaResource.lastPublished().applyValue({ args0 -> args0 })

    /**
     * The details of the latest operation. ex: status, error
     */
    public val latestOperationResult: Output<LatestOperationResultResponse>
        get() = javaResource.latestOperationResult().applyValue({ args0 ->
            args0.let({ args0 ->
                latestOperationResultResponseToKotlin(args0)
            })
        })

    /**
     * The location of the resource.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning status of the resource.
     */
    public val provisioningState: Output<String>?
        get() = javaResource.provisioningState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Describes the readiness of this environment setting
     */
    public val publishingState: Output<String>
        get() = javaResource.publishingState().applyValue({ args0 -> args0 })

    /**
     * The resource specific settings
     */
    public val resourceSettings: Output<ResourceSettingsResponse>
        get() = javaResource.resourceSettings().applyValue({ args0 ->
            args0.let({ args0 ->
                resourceSettingsResponseToKotlin(args0)
            })
        })

    /**
     * The tags of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Brief title describing the environment and its resource settings
     */
    public val title: Output<String>?
        get() = javaResource.title().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The unique immutable identifier of a resource (Guid).
     */
    public val uniqueIdentifier: Output<String>?
        get() = javaResource.uniqueIdentifier().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object EnvironmentSettingMapper : ResourceMapper<EnvironmentSetting> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.labservices.EnvironmentSetting::class == javaResource::class

    override fun map(javaResource: Resource): EnvironmentSetting = EnvironmentSetting(
        javaResource as
            com.pulumi.azurenative.labservices.EnvironmentSetting,
    )
}

/**
 * @see [EnvironmentSetting].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EnvironmentSetting].
 */
public suspend fun environmentSetting(
    name: String,
    block: suspend EnvironmentSettingResourceBuilder.() -> Unit,
): EnvironmentSetting {
    val builder = EnvironmentSettingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EnvironmentSetting].
 * @param name The _unique_ name of the resulting resource.
 */
public fun environmentSetting(name: String): EnvironmentSetting {
    val builder = EnvironmentSettingResourceBuilder()
    builder.name(name)
    return builder.build()
}
