@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin

import com.pulumi.azurenative.labservices.GalleryImageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Represents an image from the Azure Marketplace
 * Azure REST API version: 2018-10-15. Prior API version in Azure Native 1.x: 2018-10-15.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:labservices:GalleryImage myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LabServices/labaccounts/{labAccountName}/galleryimages/{galleryImageName}
 * ```
 * @property galleryImageName The name of the gallery Image.
 * @property isEnabled Indicates whether this gallery image is enabled.
 * @property isOverride Indicates whether this gallery has been overridden for this lab account
 * @property isPlanAuthorized Indicates if the plan has been authorized for programmatic deployment.
 * @property labAccountName The name of the lab Account.
 * @property location The location of the resource.
 * @property provisioningState The provisioning status of the resource.
 * @property resourceGroupName The name of the resource group.
 * @property tags The tags of the resource.
 * @property uniqueIdentifier The unique immutable identifier of a resource (Guid).
 */
public data class GalleryImageArgs(
    public val galleryImageName: Output<String>? = null,
    public val isEnabled: Output<Boolean>? = null,
    public val isOverride: Output<Boolean>? = null,
    public val isPlanAuthorized: Output<Boolean>? = null,
    public val labAccountName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val provisioningState: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val uniqueIdentifier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.labservices.GalleryImageArgs> {
    override fun toJava(): com.pulumi.azurenative.labservices.GalleryImageArgs =
        com.pulumi.azurenative.labservices.GalleryImageArgs.builder()
            .galleryImageName(galleryImageName?.applyValue({ args0 -> args0 }))
            .isEnabled(isEnabled?.applyValue({ args0 -> args0 }))
            .isOverride(isOverride?.applyValue({ args0 -> args0 }))
            .isPlanAuthorized(isPlanAuthorized?.applyValue({ args0 -> args0 }))
            .labAccountName(labAccountName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .provisioningState(provisioningState?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .uniqueIdentifier(uniqueIdentifier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GalleryImageArgs].
 */
@PulumiTagMarker
public class GalleryImageArgsBuilder internal constructor() {
    private var galleryImageName: Output<String>? = null

    private var isEnabled: Output<Boolean>? = null

    private var isOverride: Output<Boolean>? = null

    private var isPlanAuthorized: Output<Boolean>? = null

    private var labAccountName: Output<String>? = null

    private var location: Output<String>? = null

    private var provisioningState: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var uniqueIdentifier: Output<String>? = null

    /**
     * @param value The name of the gallery Image.
     */
    @JvmName("maiqqkleulnqvjga")
    public suspend fun galleryImageName(`value`: Output<String>) {
        this.galleryImageName = value
    }

    /**
     * @param value Indicates whether this gallery image is enabled.
     */
    @JvmName("unrecqcveviphkca")
    public suspend fun isEnabled(`value`: Output<Boolean>) {
        this.isEnabled = value
    }

    /**
     * @param value Indicates whether this gallery has been overridden for this lab account
     */
    @JvmName("dgkciastpbmuofxa")
    public suspend fun isOverride(`value`: Output<Boolean>) {
        this.isOverride = value
    }

    /**
     * @param value Indicates if the plan has been authorized for programmatic deployment.
     */
    @JvmName("jmwmvtjpweotwqwt")
    public suspend fun isPlanAuthorized(`value`: Output<Boolean>) {
        this.isPlanAuthorized = value
    }

    /**
     * @param value The name of the lab Account.
     */
    @JvmName("vrlotkqrniyvbbkr")
    public suspend fun labAccountName(`value`: Output<String>) {
        this.labAccountName = value
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("scvserxtqkvuccon")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The provisioning status of the resource.
     */
    @JvmName("xkgapbnpyrgwikon")
    public suspend fun provisioningState(`value`: Output<String>) {
        this.provisioningState = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("vqiuwattwirncfye")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("wjbxteatgglqaflv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The unique immutable identifier of a resource (Guid).
     */
    @JvmName("uiurykirbymkbsgt")
    public suspend fun uniqueIdentifier(`value`: Output<String>) {
        this.uniqueIdentifier = value
    }

    /**
     * @param value The name of the gallery Image.
     */
    @JvmName("cukvyxcalhftjpqq")
    public suspend fun galleryImageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.galleryImageName = mapped
    }

    /**
     * @param value Indicates whether this gallery image is enabled.
     */
    @JvmName("ollhgoperjkpwjjt")
    public suspend fun isEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isEnabled = mapped
    }

    /**
     * @param value Indicates whether this gallery has been overridden for this lab account
     */
    @JvmName("pjblogalafgjouuf")
    public suspend fun isOverride(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isOverride = mapped
    }

    /**
     * @param value Indicates if the plan has been authorized for programmatic deployment.
     */
    @JvmName("ijgtbphwercqqnwe")
    public suspend fun isPlanAuthorized(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isPlanAuthorized = mapped
    }

    /**
     * @param value The name of the lab Account.
     */
    @JvmName("mvvogfssktpxtlri")
    public suspend fun labAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labAccountName = mapped
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("tlqnbnfvkmhbhjrr")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The provisioning status of the resource.
     */
    @JvmName("ykktjydehiaxynyv")
    public suspend fun provisioningState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("nentaiqvdnqaythc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("tmyynkxhftwoxpfx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags of the resource.
     */
    @JvmName("ysatykbcwwsexwgm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The unique immutable identifier of a resource (Guid).
     */
    @JvmName("mkhviwibfywehelg")
    public suspend fun uniqueIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uniqueIdentifier = mapped
    }

    internal fun build(): GalleryImageArgs = GalleryImageArgs(
        galleryImageName = galleryImageName,
        isEnabled = isEnabled,
        isOverride = isOverride,
        isPlanAuthorized = isPlanAuthorized,
        labAccountName = labAccountName,
        location = location,
        provisioningState = provisioningState,
        resourceGroupName = resourceGroupName,
        tags = tags,
        uniqueIdentifier = uniqueIdentifier,
    )
}
