@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin

import com.pulumi.azurenative.labservices.LabArgs.builder
import com.pulumi.azurenative.labservices.kotlin.inputs.AutoShutdownProfileArgs
import com.pulumi.azurenative.labservices.kotlin.inputs.AutoShutdownProfileArgsBuilder
import com.pulumi.azurenative.labservices.kotlin.inputs.ConnectionProfileArgs
import com.pulumi.azurenative.labservices.kotlin.inputs.ConnectionProfileArgsBuilder
import com.pulumi.azurenative.labservices.kotlin.inputs.LabNetworkProfileArgs
import com.pulumi.azurenative.labservices.kotlin.inputs.LabNetworkProfileArgsBuilder
import com.pulumi.azurenative.labservices.kotlin.inputs.RosterProfileArgs
import com.pulumi.azurenative.labservices.kotlin.inputs.RosterProfileArgsBuilder
import com.pulumi.azurenative.labservices.kotlin.inputs.SecurityProfileArgs
import com.pulumi.azurenative.labservices.kotlin.inputs.SecurityProfileArgsBuilder
import com.pulumi.azurenative.labservices.kotlin.inputs.VirtualMachineProfileArgs
import com.pulumi.azurenative.labservices.kotlin.inputs.VirtualMachineProfileArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The lab resource.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2018-10-15.
 * Other available API versions: 2018-10-15, 2023-06-07.
 * ## Example Usage
 * ### putLab
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var lab = new AzureNative.LabServices.Lab("lab", new()
 *     {
 *         AutoShutdownProfile = new AzureNative.LabServices.Inputs.AutoShutdownProfileArgs
 *         {
 *             DisconnectDelay = "PT5M",
 *             IdleDelay = "PT5M",
 *             NoConnectDelay = "PT5M",
 *             ShutdownOnDisconnect = AzureNative.LabServices.EnableState.Enabled,
 *             ShutdownOnIdle = AzureNative.LabServices.ShutdownOnIdleMode.UserAbsence,
 *             ShutdownWhenNotConnected = AzureNative.LabServices.EnableState.Enabled,
 *         },
 *         ConnectionProfile = new AzureNative.LabServices.Inputs.ConnectionProfileArgs
 *         {
 *             ClientRdpAccess = AzureNative.LabServices.ConnectionType.Public,
 *             ClientSshAccess = AzureNative.LabServices.ConnectionType.Public,
 *             WebRdpAccess = AzureNative.LabServices.ConnectionType.None,
 *             WebSshAccess = AzureNative.LabServices.ConnectionType.None,
 *         },
 *         Description = "This is a test lab.",
 *         LabName = "testlab",
 *         LabPlanId = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.LabServices/labPlans/testlabplan",
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.LabServices.Inputs.LabNetworkProfileArgs
 *         {
 *             SubnetId = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/default",
 *         },
 *         ResourceGroupName = "testrg123",
 *         SecurityProfile = new AzureNative.LabServices.Inputs.SecurityProfileArgs
 *         {
 *             OpenAccess = AzureNative.LabServices.EnableState.Disabled,
 *         },
 *         Title = "Test Lab",
 *         VirtualMachineProfile = new AzureNative.LabServices.Inputs.VirtualMachineProfileArgs
 *         {
 *             AdditionalCapabilities = new AzureNative.LabServices.Inputs.VirtualMachineAdditionalCapabilitiesArgs
 *             {
 *                 InstallGpuDrivers = AzureNative.LabServices.EnableState.Disabled,
 *             },
 *             AdminUser = new AzureNative.LabServices.Inputs.CredentialsArgs
 *             {
 *                 Username = "test-user",
 *             },
 *             CreateOption = AzureNative.LabServices.CreateOption.TemplateVM,
 *             ImageReference = new AzureNative.LabServices.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "WindowsServer",
 *                 Publisher = "Microsoft",
 *                 Sku = "2019-Datacenter",
 *                 Version = "2019.0.20190410",
 *             },
 *             Sku = new AzureNative.LabServices.Inputs.SkuArgs
 *             {
 *                 Name = "Medium",
 *             },
 *             UsageQuota = "PT10H",
 *             UseSharedPassword = AzureNative.LabServices.EnableState.Disabled,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/labservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := labservices.NewLab(ctx, "lab", &labservices.LabArgs{
 * 			AutoShutdownProfile: &labservices.AutoShutdownProfileArgs{
 * 				DisconnectDelay:          pulumi.String("PT5M"),
 * 				IdleDelay:                pulumi.String("PT5M"),
 * 				NoConnectDelay:           pulumi.String("PT5M"),
 * 				ShutdownOnDisconnect:     labservices.EnableStateEnabled,
 * 				ShutdownOnIdle:           labservices.ShutdownOnIdleModeUserAbsence,
 * 				ShutdownWhenNotConnected: labservices.EnableStateEnabled,
 * 			},
 * 			ConnectionProfile: &labservices.ConnectionProfileArgs{
 * 				ClientRdpAccess: labservices.ConnectionTypePublic,
 * 				ClientSshAccess: labservices.ConnectionTypePublic,
 * 				WebRdpAccess:    labservices.ConnectionTypeNone,
 * 				WebSshAccess:    labservices.ConnectionTypeNone,
 * 			},
 * 			Description: pulumi.String("This is a test lab."),
 * 			LabName:     pulumi.String("testlab"),
 * 			LabPlanId:   pulumi.String("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.LabServices/labPlans/testlabplan"),
 * 			Location:    pulumi.String("westus"),
 * 			NetworkProfile: &labservices.LabNetworkProfileArgs{
 * 				SubnetId: pulumi.String("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/default"),
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 			SecurityProfile: &labservices.SecurityProfileArgs{
 * 				OpenAccess: labservices.EnableStateDisabled,
 * 			},
 * 			Title: pulumi.String("Test Lab"),
 * 			VirtualMachineProfile: labservices.VirtualMachineProfileResponse{
 * 				AdditionalCapabilities: &labservices.VirtualMachineAdditionalCapabilitiesArgs{
 * 					InstallGpuDrivers: labservices.EnableStateDisabled,
 * 				},
 * 				AdminUser: &labservices.CredentialsArgs{
 * 					Username: pulumi.String("test-user"),
 * 				},
 * 				CreateOption: labservices.CreateOptionTemplateVM,
 * 				ImageReference: &labservices.ImageReferenceArgs{
 * 					Offer:     pulumi.String("WindowsServer"),
 * 					Publisher: pulumi.String("Microsoft"),
 * 					Sku:       pulumi.String("2019-Datacenter"),
 * 					Version:   pulumi.String("2019.0.20190410"),
 * 				},
 * 				Sku: &labservices.SkuArgs{
 * 					Name: pulumi.String("Medium"),
 * 				},
 * 				UsageQuota:        pulumi.String("PT10H"),
 * 				UseSharedPassword: labservices.EnableStateDisabled,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.labservices.Lab;
 * import com.pulumi.azurenative.labservices.LabArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var lab = new Lab("lab", LabArgs.builder()
 *             .autoShutdownProfile(Map.ofEntries(
 *                 Map.entry("disconnectDelay", "PT5M"),
 *                 Map.entry("idleDelay", "PT5M"),
 *                 Map.entry("noConnectDelay", "PT5M"),
 *                 Map.entry("shutdownOnDisconnect", "Enabled"),
 *                 Map.entry("shutdownOnIdle", "UserAbsence"),
 *                 Map.entry("shutdownWhenNotConnected", "Enabled")
 *             ))
 *             .connectionProfile(Map.ofEntries(
 *                 Map.entry("clientRdpAccess", "Public"),
 *                 Map.entry("clientSshAccess", "Public"),
 *                 Map.entry("webRdpAccess", "None"),
 *                 Map.entry("webSshAccess", "None")
 *             ))
 *             .description("This is a test lab.")
 *             .labName("testlab")
 *             .labPlanId("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.LabServices/labPlans/testlabplan")
 *             .location("westus")
 *             .networkProfile(Map.of("subnetId", "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/default"))
 *             .resourceGroupName("testrg123")
 *             .securityProfile(Map.of("openAccess", "Disabled"))
 *             .title("Test Lab")
 *             .virtualMachineProfile(Map.ofEntries(
 *                 Map.entry("additionalCapabilities", Map.of("installGpuDrivers", "Disabled")),
 *                 Map.entry("adminUser", Map.of("username", "test-user")),
 *                 Map.entry("createOption", "TemplateVM"),
 *                 Map.entry("imageReference", Map.ofEntries(
 *                     Map.entry("offer", "WindowsServer"),
 *                     Map.entry("publisher", "Microsoft"),
 *                     Map.entry("sku", "2019-Datacenter"),
 *                     Map.entry("version", "2019.0.20190410")
 *                 )),
 *                 Map.entry("sku", Map.of("name", "Medium")),
 *                 Map.entry("usageQuota", "PT10H"),
 *                 Map.entry("useSharedPassword", "Disabled")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:labservices:Lab testlabplan /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LabServices/labs/{labName}
 * ```
 * @property autoShutdownProfile The resource auto shutdown configuration for the lab. This controls whether actions are taken on resources that are sitting idle.
 * @property connectionProfile The connection profile for the lab. This controls settings such as web access to lab resources or whether RDP or SSH ports are open.
 * @property description The description of the lab.
 * @property labName The name of the lab that uniquely identifies it within containing lab plan. Used in resource URIs.
 * @property labPlanId The ID of the lab plan. Used during resource creation to provide defaults and acts as a permission container when creating a lab via labs.azure.com. Setting a labPlanId on an existing lab provides organization..
 * @property location The geo-location where the resource lives
 * @property networkProfile The network profile for the lab, typically applied via a lab plan. This profile cannot be modified once a lab has been created.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property rosterProfile The lab user list management profile.
 * @property securityProfile The lab security profile.
 * @property tags Resource tags.
 * @property title The title of the lab.
 * @property virtualMachineProfile The profile used for creating lab virtual machines.
 */
public data class LabArgs(
    public val autoShutdownProfile: Output<AutoShutdownProfileArgs>? = null,
    public val connectionProfile: Output<ConnectionProfileArgs>? = null,
    public val description: Output<String>? = null,
    public val labName: Output<String>? = null,
    public val labPlanId: Output<String>? = null,
    public val location: Output<String>? = null,
    public val networkProfile: Output<LabNetworkProfileArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val rosterProfile: Output<RosterProfileArgs>? = null,
    public val securityProfile: Output<SecurityProfileArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val title: Output<String>? = null,
    public val virtualMachineProfile: Output<VirtualMachineProfileArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.labservices.LabArgs> {
    override fun toJava(): com.pulumi.azurenative.labservices.LabArgs =
        com.pulumi.azurenative.labservices.LabArgs.builder()
            .autoShutdownProfile(
                autoShutdownProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .connectionProfile(connectionProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .labName(labName?.applyValue({ args0 -> args0 }))
            .labPlanId(labPlanId?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .networkProfile(networkProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .rosterProfile(rosterProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .securityProfile(securityProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .title(title?.applyValue({ args0 -> args0 }))
            .virtualMachineProfile(
                virtualMachineProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [LabArgs].
 */
@PulumiTagMarker
public class LabArgsBuilder internal constructor() {
    private var autoShutdownProfile: Output<AutoShutdownProfileArgs>? = null

    private var connectionProfile: Output<ConnectionProfileArgs>? = null

    private var description: Output<String>? = null

    private var labName: Output<String>? = null

    private var labPlanId: Output<String>? = null

    private var location: Output<String>? = null

    private var networkProfile: Output<LabNetworkProfileArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var rosterProfile: Output<RosterProfileArgs>? = null

    private var securityProfile: Output<SecurityProfileArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var title: Output<String>? = null

    private var virtualMachineProfile: Output<VirtualMachineProfileArgs>? = null

    /**
     * @param value The resource auto shutdown configuration for the lab. This controls whether actions are taken on resources that are sitting idle.
     */
    @JvmName("nuvbtvduodyaywel")
    public suspend fun autoShutdownProfile(`value`: Output<AutoShutdownProfileArgs>) {
        this.autoShutdownProfile = value
    }

    /**
     * @param value The connection profile for the lab. This controls settings such as web access to lab resources or whether RDP or SSH ports are open.
     */
    @JvmName("wttyutujyohgabvk")
    public suspend fun connectionProfile(`value`: Output<ConnectionProfileArgs>) {
        this.connectionProfile = value
    }

    /**
     * @param value The description of the lab.
     */
    @JvmName("ghevygggejrrusiy")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the lab that uniquely identifies it within containing lab plan. Used in resource URIs.
     */
    @JvmName("jescyiywjvlohdyt")
    public suspend fun labName(`value`: Output<String>) {
        this.labName = value
    }

    /**
     * @param value The ID of the lab plan. Used during resource creation to provide defaults and acts as a permission container when creating a lab via labs.azure.com. Setting a labPlanId on an existing lab provides organization..
     */
    @JvmName("xqgypwjitxvaesvk")
    public suspend fun labPlanId(`value`: Output<String>) {
        this.labPlanId = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("vrroaeyqnsrnyhdq")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The network profile for the lab, typically applied via a lab plan. This profile cannot be modified once a lab has been created.
     */
    @JvmName("skkpkylttorkksyd")
    public suspend fun networkProfile(`value`: Output<LabNetworkProfileArgs>) {
        this.networkProfile = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mwjlihupailnmvlx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The lab user list management profile.
     */
    @JvmName("quujkrwdapmknrfb")
    public suspend fun rosterProfile(`value`: Output<RosterProfileArgs>) {
        this.rosterProfile = value
    }

    /**
     * @param value The lab security profile.
     */
    @JvmName("wipnfjrarvbxubko")
    public suspend fun securityProfile(`value`: Output<SecurityProfileArgs>) {
        this.securityProfile = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("nepylvnadoaektmg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The title of the lab.
     */
    @JvmName("sywshlqvgtboiryg")
    public suspend fun title(`value`: Output<String>) {
        this.title = value
    }

    /**
     * @param value The profile used for creating lab virtual machines.
     */
    @JvmName("fhukwlswrhpxteik")
    public suspend fun virtualMachineProfile(`value`: Output<VirtualMachineProfileArgs>) {
        this.virtualMachineProfile = value
    }

    /**
     * @param value The resource auto shutdown configuration for the lab. This controls whether actions are taken on resources that are sitting idle.
     */
    @JvmName("utjcbapqeglnlkgb")
    public suspend fun autoShutdownProfile(`value`: AutoShutdownProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoShutdownProfile = mapped
    }

    /**
     * @param argument The resource auto shutdown configuration for the lab. This controls whether actions are taken on resources that are sitting idle.
     */
    @JvmName("wukqmlwwyabwghuf")
    public suspend
    fun autoShutdownProfile(argument: suspend AutoShutdownProfileArgsBuilder.() -> Unit) {
        val toBeMapped = AutoShutdownProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.autoShutdownProfile = mapped
    }

    /**
     * @param value The connection profile for the lab. This controls settings such as web access to lab resources or whether RDP or SSH ports are open.
     */
    @JvmName("kobrcsoqwvrvifrs")
    public suspend fun connectionProfile(`value`: ConnectionProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionProfile = mapped
    }

    /**
     * @param argument The connection profile for the lab. This controls settings such as web access to lab resources or whether RDP or SSH ports are open.
     */
    @JvmName("hqefgxswhuxobosl")
    public suspend fun connectionProfile(argument: suspend ConnectionProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectionProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectionProfile = mapped
    }

    /**
     * @param value The description of the lab.
     */
    @JvmName("exrnsqniiiohqnhy")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the lab that uniquely identifies it within containing lab plan. Used in resource URIs.
     */
    @JvmName("slaqaepsxnlkqfst")
    public suspend fun labName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labName = mapped
    }

    /**
     * @param value The ID of the lab plan. Used during resource creation to provide defaults and acts as a permission container when creating a lab via labs.azure.com. Setting a labPlanId on an existing lab provides organization..
     */
    @JvmName("pkmecsiwynceeedv")
    public suspend fun labPlanId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labPlanId = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("dydmamdgnblbgxtl")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The network profile for the lab, typically applied via a lab plan. This profile cannot be modified once a lab has been created.
     */
    @JvmName("tsiggufmrpjsjeyq")
    public suspend fun networkProfile(`value`: LabNetworkProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkProfile = mapped
    }

    /**
     * @param argument The network profile for the lab, typically applied via a lab plan. This profile cannot be modified once a lab has been created.
     */
    @JvmName("xnqpbowsxkkbshru")
    public suspend fun networkProfile(argument: suspend LabNetworkProfileArgsBuilder.() -> Unit) {
        val toBeMapped = LabNetworkProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkProfile = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rktrmjwkerphjijy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The lab user list management profile.
     */
    @JvmName("olklsnvrgulrqciv")
    public suspend fun rosterProfile(`value`: RosterProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rosterProfile = mapped
    }

    /**
     * @param argument The lab user list management profile.
     */
    @JvmName("egojxnxylfiwceoj")
    public suspend fun rosterProfile(argument: suspend RosterProfileArgsBuilder.() -> Unit) {
        val toBeMapped = RosterProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.rosterProfile = mapped
    }

    /**
     * @param value The lab security profile.
     */
    @JvmName("hhtlgkombfsicmce")
    public suspend fun securityProfile(`value`: SecurityProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityProfile = mapped
    }

    /**
     * @param argument The lab security profile.
     */
    @JvmName("yvchhiepmncdoxjq")
    public suspend fun securityProfile(argument: suspend SecurityProfileArgsBuilder.() -> Unit) {
        val toBeMapped = SecurityProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.securityProfile = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("tbmljklpobbejfgc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("yfeseywqdihsuklh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The title of the lab.
     */
    @JvmName("mvxikjijwsdchlyu")
    public suspend fun title(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.title = mapped
    }

    /**
     * @param value The profile used for creating lab virtual machines.
     */
    @JvmName("mqngvgchtkjvdpfj")
    public suspend fun virtualMachineProfile(`value`: VirtualMachineProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualMachineProfile = mapped
    }

    /**
     * @param argument The profile used for creating lab virtual machines.
     */
    @JvmName("telcqgswnoaetmsr")
    public suspend
    fun virtualMachineProfile(argument: suspend VirtualMachineProfileArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachineProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.virtualMachineProfile = mapped
    }

    internal fun build(): LabArgs = LabArgs(
        autoShutdownProfile = autoShutdownProfile,
        connectionProfile = connectionProfile,
        description = description,
        labName = labName,
        labPlanId = labPlanId,
        location = location,
        networkProfile = networkProfile,
        resourceGroupName = resourceGroupName,
        rosterProfile = rosterProfile,
        securityProfile = securityProfile,
        tags = tags,
        title = title,
        virtualMachineProfile = virtualMachineProfile,
    )
}
