@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The enabled access level for Web Access over SSH.
 */
public enum class ConnectionType(
    public val javaValue: com.pulumi.azurenative.labservices.enums.ConnectionType,
) : ConvertibleToJava<com.pulumi.azurenative.labservices.enums.ConnectionType> {
    Public(com.pulumi.azurenative.labservices.enums.ConnectionType.Public),
    Private(com.pulumi.azurenative.labservices.enums.ConnectionType.Private),
    None(com.pulumi.azurenative.labservices.enums.ConnectionType.None),
    ;

    override fun toJava(): com.pulumi.azurenative.labservices.enums.ConnectionType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.labservices.enums.ConnectionType):
            ConnectionType = ConnectionType.values().first { it.javaValue == javaType }
    }
}
