@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The size of the virtual machine
 */
public enum class ManagedLabVmSize(
    public val javaValue: com.pulumi.azurenative.labservices.enums.ManagedLabVmSize,
) : ConvertibleToJava<com.pulumi.azurenative.labservices.enums.ManagedLabVmSize> {
    /**
     * The base VM size
     */
    Basic(com.pulumi.azurenative.labservices.enums.ManagedLabVmSize.Basic),

    /**
     * The standard or default VM size
     */
    Standard(com.pulumi.azurenative.labservices.enums.ManagedLabVmSize.Standard),

    /**
     * The most performant VM size
     */
    Performance(com.pulumi.azurenative.labservices.enums.ManagedLabVmSize.Performance),
    ;

    override fun toJava(): com.pulumi.azurenative.labservices.enums.ManagedLabVmSize = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.labservices.enums.ManagedLabVmSize):
            ManagedLabVmSize = ManagedLabVmSize.values().first { it.javaValue == javaType }
    }
}
