@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.inputs

import com.pulumi.azurenative.labservices.inputs.GetGlobalUserPersonalPreferencesPlainArgs.builder
import com.pulumi.azurenative.labservices.kotlin.enums.AddRemove
import com.pulumi.core.Either
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property addRemove Enum indicating if user is adding or removing a favorite lab
 * @property labAccountResourceId Resource Id of the lab account
 * @property labResourceId Resource Id of the lab to add/remove from the favorites list
 * @property userName The name of the user.
 */
public data class GetGlobalUserPersonalPreferencesPlainArgs(
    public val addRemove: Either<String, AddRemove>? = null,
    public val labAccountResourceId: String? = null,
    public val labResourceId: String? = null,
    public val userName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.labservices.inputs.GetGlobalUserPersonalPreferencesPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.labservices.inputs.GetGlobalUserPersonalPreferencesPlainArgs =
        com.pulumi.azurenative.labservices.inputs.GetGlobalUserPersonalPreferencesPlainArgs.builder()
            .addRemove(
                addRemove?.let({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .labAccountResourceId(labAccountResourceId?.let({ args0 -> args0 }))
            .labResourceId(labResourceId?.let({ args0 -> args0 }))
            .userName(userName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGlobalUserPersonalPreferencesPlainArgs].
 */
@PulumiTagMarker
public class GetGlobalUserPersonalPreferencesPlainArgsBuilder internal constructor() {
    private var addRemove: Either<String, AddRemove>? = null

    private var labAccountResourceId: String? = null

    private var labResourceId: String? = null

    private var userName: String? = null

    /**
     * @param value Enum indicating if user is adding or removing a favorite lab
     */
    @JvmName("wvqfvqjytexflhuu")
    public suspend fun addRemove(`value`: Either<String, AddRemove>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.addRemove = mapped
    }

    /**
     * @param value Enum indicating if user is adding or removing a favorite lab
     */
    @JvmName("yrflwdivnfuoirkm")
    public fun addRemove(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AddRemove>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.addRemove = mapped
    }

    /**
     * @param value Enum indicating if user is adding or removing a favorite lab
     */
    @JvmName("apmgwohscjvdvict")
    public fun addRemove(`value`: AddRemove) {
        val toBeMapped = Either.ofRight<String, AddRemove>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.addRemove = mapped
    }

    /**
     * @param value Resource Id of the lab account
     */
    @JvmName("tupuovdkmehhumek")
    public suspend fun labAccountResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.labAccountResourceId = mapped
    }

    /**
     * @param value Resource Id of the lab to add/remove from the favorites list
     */
    @JvmName("ulxjbcnnmapojjyw")
    public suspend fun labResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.labResourceId = mapped
    }

    /**
     * @param value The name of the user.
     */
    @JvmName("iflpquwpkchgiebl")
    public suspend fun userName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.userName = mapped
    }

    internal fun build(): GetGlobalUserPersonalPreferencesPlainArgs =
        GetGlobalUserPersonalPreferencesPlainArgs(
            addRemove = addRemove,
            labAccountResourceId = labAccountResourceId,
            labResourceId = labResourceId,
            userName = userName ?: throw PulumiNullFieldException("userName"),
        )
}
