@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.inputs

import com.pulumi.azurenative.labservices.inputs.GetLabAccountPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand Specify the $expand query. Example: 'properties($expand=sizeConfiguration)'
 * @property labAccountName The name of the lab Account.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetLabAccountPlainArgs(
    public val expand: String? = null,
    public val labAccountName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.labservices.inputs.GetLabAccountPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.labservices.inputs.GetLabAccountPlainArgs =
        com.pulumi.azurenative.labservices.inputs.GetLabAccountPlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .labAccountName(labAccountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLabAccountPlainArgs].
 */
@PulumiTagMarker
public class GetLabAccountPlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var labAccountName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Specify the $expand query. Example: 'properties($expand=sizeConfiguration)'
     */
    @JvmName("jkeoacmadxeqwwxh")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the lab Account.
     */
    @JvmName("srmvpdilpumdoelg")
    public suspend fun labAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.labAccountName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("isouovobrusmkatn")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetLabAccountPlainArgs = GetLabAccountPlainArgs(
        expand = expand,
        labAccountName = labAccountName ?: throw PulumiNullFieldException("labAccountName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
