@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.inputs

import com.pulumi.azurenative.labservices.inputs.LabPlanNetworkProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Profile for how to handle networking for Lab Plans.
 * @property subnetId The external subnet resource id
 */
public data class LabPlanNetworkProfileArgs(
    public val subnetId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.labservices.inputs.LabPlanNetworkProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.labservices.inputs.LabPlanNetworkProfileArgs =
        com.pulumi.azurenative.labservices.inputs.LabPlanNetworkProfileArgs.builder()
            .subnetId(subnetId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LabPlanNetworkProfileArgs].
 */
@PulumiTagMarker
public class LabPlanNetworkProfileArgsBuilder internal constructor() {
    private var subnetId: Output<String>? = null

    /**
     * @param value The external subnet resource id
     */
    @JvmName("vvbbtyavyjwwebqy")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value The external subnet resource id
     */
    @JvmName("lykjnhnyfeiemepf")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    internal fun build(): LabPlanNetworkProfileArgs = LabPlanNetworkProfileArgs(
        subnetId = subnetId,
    )
}
