@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.inputs

import com.pulumi.azurenative.labservices.inputs.ListGlobalUserEnvironmentsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property labId The resource Id of the lab
 * @property userName The name of the user.
 */
public data class ListGlobalUserEnvironmentsPlainArgs(
    public val labId: String? = null,
    public val userName: String,
) : ConvertibleToJava<com.pulumi.azurenative.labservices.inputs.ListGlobalUserEnvironmentsPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.labservices.inputs.ListGlobalUserEnvironmentsPlainArgs =
        com.pulumi.azurenative.labservices.inputs.ListGlobalUserEnvironmentsPlainArgs.builder()
            .labId(labId?.let({ args0 -> args0 }))
            .userName(userName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListGlobalUserEnvironmentsPlainArgs].
 */
@PulumiTagMarker
public class ListGlobalUserEnvironmentsPlainArgsBuilder internal constructor() {
    private var labId: String? = null

    private var userName: String? = null

    /**
     * @param value The resource Id of the lab
     */
    @JvmName("grrsdsgxfhnxuajc")
    public suspend fun labId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.labId = mapped
    }

    /**
     * @param value The name of the user.
     */
    @JvmName("uckfqeoocgburivj")
    public suspend fun userName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.userName = mapped
    }

    internal fun build(): ListGlobalUserEnvironmentsPlainArgs = ListGlobalUserEnvironmentsPlainArgs(
        labId = labId,
        userName = userName ?: throw PulumiNullFieldException("userName"),
    )
}
