@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.inputs

import com.pulumi.azurenative.labservices.inputs.ListGlobalUserLabsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property userName The name of the user.
 */
public data class ListGlobalUserLabsPlainArgs(
    public val userName: String,
) : ConvertibleToJava<com.pulumi.azurenative.labservices.inputs.ListGlobalUserLabsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.labservices.inputs.ListGlobalUserLabsPlainArgs =
        com.pulumi.azurenative.labservices.inputs.ListGlobalUserLabsPlainArgs.builder()
            .userName(userName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListGlobalUserLabsPlainArgs].
 */
@PulumiTagMarker
public class ListGlobalUserLabsPlainArgsBuilder internal constructor() {
    private var userName: String? = null

    /**
     * @param value The name of the user.
     */
    @JvmName("hivbocofugdyiwvm")
    public suspend fun userName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.userName = mapped
    }

    internal fun build(): ListGlobalUserLabsPlainArgs = ListGlobalUserLabsPlainArgs(
        userName = userName ?: throw PulumiNullFieldException("userName"),
    )
}
