@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.inputs

import com.pulumi.azurenative.labservices.inputs.RecurrencePatternArgs.builder
import com.pulumi.azurenative.labservices.kotlin.enums.RecurrenceFrequency
import com.pulumi.azurenative.labservices.kotlin.enums.WeekDay
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Recurrence pattern of a lab schedule.
 * @property expirationDate When the recurrence will expire. This date is inclusive.
 * @property frequency The frequency of the recurrence.
 * @property interval The interval to invoke the schedule on. For example, interval = 2 and RecurrenceFrequency.Daily will run every 2 days. When no interval is supplied, an interval of 1 is used.
 * @property weekDays The week days the schedule runs. Used for when the Frequency is set to Weekly.
 */
public data class RecurrencePatternArgs(
    public val expirationDate: Output<String>,
    public val frequency: Output<RecurrenceFrequency>,
    public val interval: Output<Int>? = null,
    public val weekDays: Output<List<WeekDay>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.labservices.inputs.RecurrencePatternArgs> {
    override fun toJava(): com.pulumi.azurenative.labservices.inputs.RecurrencePatternArgs =
        com.pulumi.azurenative.labservices.inputs.RecurrencePatternArgs.builder()
            .expirationDate(expirationDate.applyValue({ args0 -> args0 }))
            .frequency(frequency.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .interval(interval?.applyValue({ args0 -> args0 }))
            .weekDays(
                weekDays?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [RecurrencePatternArgs].
 */
@PulumiTagMarker
public class RecurrencePatternArgsBuilder internal constructor() {
    private var expirationDate: Output<String>? = null

    private var frequency: Output<RecurrenceFrequency>? = null

    private var interval: Output<Int>? = null

    private var weekDays: Output<List<WeekDay>>? = null

    /**
     * @param value When the recurrence will expire. This date is inclusive.
     */
    @JvmName("hdudxkgxfubanauu")
    public suspend fun expirationDate(`value`: Output<String>) {
        this.expirationDate = value
    }

    /**
     * @param value The frequency of the recurrence.
     */
    @JvmName("mjuxucwmjrwsfdxg")
    public suspend fun frequency(`value`: Output<RecurrenceFrequency>) {
        this.frequency = value
    }

    /**
     * @param value The interval to invoke the schedule on. For example, interval = 2 and RecurrenceFrequency.Daily will run every 2 days. When no interval is supplied, an interval of 1 is used.
     */
    @JvmName("kdoerfsbumkhbnxj")
    public suspend fun interval(`value`: Output<Int>) {
        this.interval = value
    }

    /**
     * @param value The week days the schedule runs. Used for when the Frequency is set to Weekly.
     */
    @JvmName("fxahexaovrhacrlg")
    public suspend fun weekDays(`value`: Output<List<WeekDay>>) {
        this.weekDays = value
    }

    @JvmName("vgbdyfvoypfsficu")
    public suspend fun weekDays(vararg values: Output<WeekDay>) {
        this.weekDays = Output.all(values.asList())
    }

    /**
     * @param values The week days the schedule runs. Used for when the Frequency is set to Weekly.
     */
    @JvmName("lvjdkygvoageshxk")
    public suspend fun weekDays(values: List<Output<WeekDay>>) {
        this.weekDays = Output.all(values)
    }

    /**
     * @param value When the recurrence will expire. This date is inclusive.
     */
    @JvmName("opsxqcldecubjuki")
    public suspend fun expirationDate(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.expirationDate = mapped
    }

    /**
     * @param value The frequency of the recurrence.
     */
    @JvmName("ujmcsfkkooyxrbxw")
    public suspend fun frequency(`value`: RecurrenceFrequency) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frequency = mapped
    }

    /**
     * @param value The interval to invoke the schedule on. For example, interval = 2 and RecurrenceFrequency.Daily will run every 2 days. When no interval is supplied, an interval of 1 is used.
     */
    @JvmName("uvmfvqoupaiypjia")
    public suspend fun interval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interval = mapped
    }

    /**
     * @param value The week days the schedule runs. Used for when the Frequency is set to Weekly.
     */
    @JvmName("sdteohgdpxfrnvne")
    public suspend fun weekDays(`value`: List<WeekDay>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weekDays = mapped
    }

    /**
     * @param values The week days the schedule runs. Used for when the Frequency is set to Weekly.
     */
    @JvmName("aucytlloopjboyhf")
    public suspend fun weekDays(vararg values: WeekDay) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.weekDays = mapped
    }

    internal fun build(): RecurrencePatternArgs = RecurrencePatternArgs(
        expirationDate = expirationDate ?: throw PulumiNullFieldException("expirationDate"),
        frequency = frequency ?: throw PulumiNullFieldException("frequency"),
        interval = interval,
        weekDays = weekDays,
    )
}
