@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.inputs

import com.pulumi.azurenative.labservices.inputs.RosterProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The lab user list management profile.
 * @property activeDirectoryGroupId The AAD group ID which this lab roster is populated from. Having this set enables AAD sync mode.
 * @property lmsInstance The base URI identifying the lms instance.
 * @property ltiClientId The unique id of the azure lab services tool in the lms.
 * @property ltiContextId The unique context identifier for the lab in the lms.
 * @property ltiRosterEndpoint The uri of the names and roles service endpoint on the lms for the class attached to this lab.
 */
public data class RosterProfileArgs(
    public val activeDirectoryGroupId: Output<String>? = null,
    public val lmsInstance: Output<String>? = null,
    public val ltiClientId: Output<String>? = null,
    public val ltiContextId: Output<String>? = null,
    public val ltiRosterEndpoint: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.labservices.inputs.RosterProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.labservices.inputs.RosterProfileArgs =
        com.pulumi.azurenative.labservices.inputs.RosterProfileArgs.builder()
            .activeDirectoryGroupId(activeDirectoryGroupId?.applyValue({ args0 -> args0 }))
            .lmsInstance(lmsInstance?.applyValue({ args0 -> args0 }))
            .ltiClientId(ltiClientId?.applyValue({ args0 -> args0 }))
            .ltiContextId(ltiContextId?.applyValue({ args0 -> args0 }))
            .ltiRosterEndpoint(ltiRosterEndpoint?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RosterProfileArgs].
 */
@PulumiTagMarker
public class RosterProfileArgsBuilder internal constructor() {
    private var activeDirectoryGroupId: Output<String>? = null

    private var lmsInstance: Output<String>? = null

    private var ltiClientId: Output<String>? = null

    private var ltiContextId: Output<String>? = null

    private var ltiRosterEndpoint: Output<String>? = null

    /**
     * @param value The AAD group ID which this lab roster is populated from. Having this set enables AAD sync mode.
     */
    @JvmName("vwdncrmiodbmnvqr")
    public suspend fun activeDirectoryGroupId(`value`: Output<String>) {
        this.activeDirectoryGroupId = value
    }

    /**
     * @param value The base URI identifying the lms instance.
     */
    @JvmName("ikngcaekwdhwlxut")
    public suspend fun lmsInstance(`value`: Output<String>) {
        this.lmsInstance = value
    }

    /**
     * @param value The unique id of the azure lab services tool in the lms.
     */
    @JvmName("ehplivbfomdykgsb")
    public suspend fun ltiClientId(`value`: Output<String>) {
        this.ltiClientId = value
    }

    /**
     * @param value The unique context identifier for the lab in the lms.
     */
    @JvmName("jlxlysqroipbujbs")
    public suspend fun ltiContextId(`value`: Output<String>) {
        this.ltiContextId = value
    }

    /**
     * @param value The uri of the names and roles service endpoint on the lms for the class attached to this lab.
     */
    @JvmName("aoqyofepwcryfjot")
    public suspend fun ltiRosterEndpoint(`value`: Output<String>) {
        this.ltiRosterEndpoint = value
    }

    /**
     * @param value The AAD group ID which this lab roster is populated from. Having this set enables AAD sync mode.
     */
    @JvmName("tvaeoioqeahrnfoc")
    public suspend fun activeDirectoryGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.activeDirectoryGroupId = mapped
    }

    /**
     * @param value The base URI identifying the lms instance.
     */
    @JvmName("yxchoctwpwtsndwq")
    public suspend fun lmsInstance(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lmsInstance = mapped
    }

    /**
     * @param value The unique id of the azure lab services tool in the lms.
     */
    @JvmName("wnscpghikqukbrmg")
    public suspend fun ltiClientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ltiClientId = mapped
    }

    /**
     * @param value The unique context identifier for the lab in the lms.
     */
    @JvmName("lylxofwnlrxqdqwi")
    public suspend fun ltiContextId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ltiContextId = mapped
    }

    /**
     * @param value The uri of the names and roles service endpoint on the lms for the class attached to this lab.
     */
    @JvmName("baoroedhnaouqera")
    public suspend fun ltiRosterEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ltiRosterEndpoint = mapped
    }

    internal fun build(): RosterProfileArgs = RosterProfileArgs(
        activeDirectoryGroupId = activeDirectoryGroupId,
        lmsInstance = lmsInstance,
        ltiClientId = ltiClientId,
        ltiContextId = ltiContextId,
        ltiRosterEndpoint = ltiRosterEndpoint,
    )
}
