@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Profile for how to handle shutting down virtual machines.
 * @property disconnectDelay The amount of time a VM will stay running after a user disconnects if this behavior is enabled.
 * @property idleDelay The amount of time a VM will idle before it is shutdown if this behavior is enabled.
 * @property noConnectDelay The amount of time a VM will stay running before it is shutdown if no connection is made and this behavior is enabled.
 * @property shutdownOnDisconnect Whether shutdown on disconnect is enabled
 * @property shutdownOnIdle Whether a VM will get shutdown when it has idled for a period of time.
 * @property shutdownWhenNotConnected Whether a VM will get shutdown when it hasn't been connected to after a period of time.
 */
public data class AutoShutdownProfileResponse(
    public val disconnectDelay: String? = null,
    public val idleDelay: String? = null,
    public val noConnectDelay: String? = null,
    public val shutdownOnDisconnect: String? = null,
    public val shutdownOnIdle: String? = null,
    public val shutdownWhenNotConnected: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.labservices.outputs.AutoShutdownProfileResponse):
            AutoShutdownProfileResponse = AutoShutdownProfileResponse(
            disconnectDelay = javaType.disconnectDelay().map({ args0 -> args0 }).orElse(null),
            idleDelay = javaType.idleDelay().map({ args0 -> args0 }).orElse(null),
            noConnectDelay = javaType.noConnectDelay().map({ args0 -> args0 }).orElse(null),
            shutdownOnDisconnect = javaType.shutdownOnDisconnect().map({ args0 -> args0 }).orElse(null),
            shutdownOnIdle = javaType.shutdownOnIdle().map({ args0 -> args0 }).orElse(null),
            shutdownWhenNotConnected = javaType.shutdownWhenNotConnected().map({ args0 -> args0 }).orElse(null),
        )
    }
}
